package cn.com.anysdk.sms.monitor.impl;

import cn.com.anysdk.sms.api.ISmsExceptionListener;
import cn.com.anysdk.sms.exception.SmsException;
import cn.com.anysdk.sms.monitor.SmsOperationContext;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class LoggingExceptionListener implements ISmsExceptionListener {
    @Override
    public void onException(SmsException exception, SmsOperationContext context) {
      log.error("SMS operation failed - provider: {}, OperationType: {}, Error: {} ",
              context.getProvider(), context.getOperationType(), exception.getMessage(),
              exception);

    }
}
