package cn.com.dabby.idaas.oidc.exception;

public class OAuth2Exception extends RuntimeException {
    private String error;
    private String errorDescription;

    public OAuth2Exception(String error, String errorDescription) {
        super("OAuth2 异常，错误码：" + error + "，错误详情：" + errorDescription);
        this.error = error;
        this.errorDescription = errorDescription;
    }

    public String getError() {
        return error;
    }

    public String getErrorDescription() {
        return errorDescription;
    }
}
