/*
 * Decompiled with CFR 0.152.
 */
package cn.com.dabby.idaas.oidc;

import cn.com.dabby.idaas.oidc.exception.OAuth2Exception;
import cn.com.dabby.idaas.oidc.pojo.IdTokenClaim;
import cn.com.dabby.idaas.oidc.pojo.OidcTokenResponse;
import cn.com.dabby.idaas.oidc.pojo.OidcUserInfo;
import cn.com.dabby.idaas.oidc.utils.Asserts;
import cn.com.dabby.idaas.oidc.utils.JsonUtils;
import cn.com.dabby.idaas.oidc.utils.StringUtils;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.nimbusds.openid.connect.sdk.validators.IDTokenValidator;
import java.net.URI;
import java.net.URL;

public class OidcClient {
    private static final Scope DEFAULT_SCOPE = new Scope(new String[]{"openid", "profile", "user_bz", "menu", "role", "permission"});
    private static final ResponseType DEFAULT_RESPONSE_TYPE = new ResponseType(new String[]{"code"});
    private final OIDCProviderMetadata oidcProviderMetadata;
    private final ClientID clientId;
    private final Secret clientSecret;
    private final URI redirectUri;
    private final Issuer issuer;
    private JWKSet jwkSet;
    private final IDTokenValidator idTokenValidator;

    public OidcClient(String issuer, String clientid, String clientSecret, String redirectUri) throws Exception {
        Asserts.hasText(issuer, "issuer \u4e0d\u80fd\u4e3a\u7a7a");
        Asserts.hasText(clientid, "clientId \u4e0d\u80fd\u4e3a\u7a7a");
        Asserts.hasText(clientSecret, "clientSecret \u4e0d\u80fd\u4e3a\u7a7a");
        Asserts.hasText(redirectUri, "redirectUri \u4e0d\u80fd\u4e3a\u7a7a");
        this.issuer = new Issuer(issuer);
        this.oidcProviderMetadata = OIDCProviderMetadata.resolve((Issuer)this.issuer);
        this.jwkSet = JWKSet.load((URL)this.oidcProviderMetadata.getJWKSetURI().toURL());
        this.clientId = new ClientID(clientid);
        this.clientSecret = new Secret(clientSecret);
        this.redirectUri = new URI(redirectUri);
        this.idTokenValidator = new IDTokenValidator(this.issuer, this.clientId, JWSAlgorithm.RS256, this.jwkSet);
    }

    public OIDCProviderMetadata getOidcProviderMetadata() {
        return this.oidcProviderMetadata;
    }

    public String buildAuthorizationUrl(String state, String nonce) {
        return new AuthenticationRequest.Builder(DEFAULT_RESPONSE_TYPE, DEFAULT_SCOPE, this.clientId, this.redirectUri).endpointURI(this.oidcProviderMetadata.getAuthorizationEndpointURI()).state(new State(state)).nonce(new Nonce(nonce)).build().toURI().toASCIIString();
    }

    public OidcTokenResponse getTokenByCode(String authorizationCode) throws Exception {
        AuthorizationCode code = new AuthorizationCode(authorizationCode);
        AuthorizationCodeGrant codeGrant = new AuthorizationCodeGrant(code, this.redirectUri);
        ClientSecretBasic clientAuth = new ClientSecretBasic(this.clientId, this.clientSecret);
        URI tokenEndpoint = this.oidcProviderMetadata.getTokenEndpointURI();
        TokenRequest request = new TokenRequest(tokenEndpoint, (ClientAuthentication)clientAuth, (AuthorizationGrant)codeGrant);
        TokenResponse tokenResponse = OIDCTokenResponseParser.parse((HTTPResponse)request.toHTTPRequest().send());
        if (!tokenResponse.indicatesSuccess()) {
            ErrorObject errorObject = tokenResponse.toErrorResponse().getErrorObject();
            String errorCode = errorObject.getCode();
            String errorDescription = errorObject.getCustomParams().getOrDefault("errorDescription", "\u672a\u77e5\u5f02\u5e38");
            throw new OAuth2Exception(errorCode, errorDescription);
        }
        String successResponseJson = tokenResponse.toSuccessResponse().getTokens().toJSONObject().toJSONString();
        return JsonUtils.fromJson(successResponseJson, OidcTokenResponse.class);
    }

    public IdTokenClaim validateIdToken(String idToken, String expectedNonce) throws Exception {
        JWT jwt = JWTParser.parse((String)idToken);
        Nonce nonce = null;
        if (!StringUtils.isBlank(expectedNonce)) {
            nonce = new Nonce(expectedNonce);
        }
        IDTokenClaimsSet idTokenClaims = this.idTokenValidator.validate(jwt, nonce);
        String json = idTokenClaims.toJSONString();
        return JsonUtils.fromJson(json, IdTokenClaim.class);
    }

    public OidcUserInfo getUserInfo(String accessToken) throws Exception {
        BearerAccessToken token;
        URI userInfoEndpoint = this.oidcProviderMetadata.getUserInfoEndpointURI();
        HTTPResponse httpResponse = new UserInfoRequest(userInfoEndpoint, (AccessToken)(token = new BearerAccessToken(accessToken))).toHTTPRequest().send();
        UserInfoResponse userInfoResponse = UserInfoResponse.parse((HTTPResponse)httpResponse);
        if (!userInfoResponse.indicatesSuccess()) {
            ErrorObject errorObject = userInfoResponse.toErrorResponse().getErrorObject();
            String errorCode = errorObject.getCode();
            String errorDescription = errorObject.getCustomParams().getOrDefault("errorDescription", "\u672a\u77e5\u5f02\u5e38");
            throw new OAuth2Exception(errorCode, errorDescription);
        }
        String userInfoJson = userInfoResponse.toSuccessResponse().getUserInfo().toJSONString();
        return JsonUtils.fromJson(userInfoJson, OidcUserInfo.class);
    }
}

