package cn.com.dabby.idaas.oidc.utils;

import cn.com.dabby.idaas.oidc.exception.JsonException;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;

public final class JsonUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper()
            .setPropertyNamingStrategy(new PropertyNamingStrategy.SnakeCaseStrategy())
            .setSerializationInclusion(JsonInclude.Include.NON_NULL)
            .enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)
            .disable(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES);

    private JsonUtils() {

    }

    public static <T> String toJson(T bean) {
        try {
            return OBJECT_MAPPER.writeValueAsString(bean);
        } catch (Exception exception) {
            throw new JsonException(exception.getMessage(), exception);
        }
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        try {
            return OBJECT_MAPPER.readValue(json, clazz);
        } catch (Exception exception) {
            throw new JsonException(exception.getMessage(), exception);
        }
    }

}
