/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.cert;

import cn.net.wanmo.common.security.rsa.RsaUtil;
import cn.net.wanmo.common.util.Exceptions;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class RsaCertUtil {
    public static void createRootCA(File file) {
        try {
            String issuer;
            KeyPair keyPair = RsaUtil.getKeyPair();
            String subject = issuer = "C=CN,ST=GuangDong,L=Shenzhen,O=Skybility,OU=Cloudbility,CN=Atlas Personal License CA,E=cwjcsu@126.com";
            Certificate cert = RsaCertUtil.generateV3(issuer, subject, BigInteger.ZERO, new Date(System.currentTimeMillis() - 86400000L), new Date(System.currentTimeMillis() + 1009152000000L), keyPair.getPublic(), keyPair.getPrivate(), null);
            KeyStore store = KeyStore.getInstance("JKS");
            store.load(null, null);
            store.setKeyEntry("atlas", keyPair.getPrivate(), "atlas".toCharArray(), new Certificate[]{cert});
            cert.verify(keyPair.getPublic());
            if (file.exists() || file.createNewFile()) {
                store.store(new FileOutputStream(file), "atlas".toCharArray());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Certificate generateV3(String issuer, String subject, BigInteger serial, Date notBefore, Date notAfter, PublicKey publicKey, PrivateKey privKey, List<Extension> extensions) {
        try {
            JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(new X500Name(issuer), serial, notBefore, notAfter, new X500Name(subject), publicKey);
            ContentSigner sigGen = new JcaContentSignerBuilder("SHA1withRSA").setProvider("BC").build(privKey);
            if (extensions == null) {
                extensions = new ArrayList<Extension>();
            }
            for (Extension ext : extensions) {
                builder.addExtension(new ASN1ObjectIdentifier(ext.getOid()), ext.isCritical(), (ASN1Encodable)ASN1Primitive.fromByteArray((byte[])ext.getValue()));
            }
            X509CertificateHolder holder = builder.build(sigGen);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream is1 = new ByteArrayInputStream(holder.toASN1Structure().getEncoded());
            X509Certificate theCert = (X509Certificate)cf.generateCertificate(is1);
            ((InputStream)is1).close();
            return theCert;
        }
        catch (Exception e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public class Extension {
        private String oid;
        private boolean critical;
        private byte[] value;

        public String getOid() {
            return this.oid;
        }

        public byte[] getValue() {
            return this.value;
        }

        public boolean isCritical() {
            return this.critical;
        }
    }
}

