/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.keytool;

import cn.net.wanmo.common.util.Exceptions;
import cn.net.wanmo.common.util.StringUtil;
import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

public class KeytoolUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyStore getKeyStore(String type, String jksFilePath, String jkdPassword) {
        try (FileInputStream inputStream = new FileInputStream(jksFilePath);){
            KeyStore ks = KeyStore.getInstance(StringUtil.isBlank((CharSequence)type) ? KeyStore.getDefaultType() : type);
            ks.load(inputStream, jkdPassword.toCharArray());
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    public static SSLContext getSSLContext(String type, KeyStore keyStore, char[] password) {
        try {
            SSLContext sslContext = SSLContext.getInstance(type);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, password);
            sslContext.init(kmf.getKeyManagers(), null, null);
            return sslContext;
        }
        catch (Exception e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }
}

