/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.cert;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;

public class CertificateCoder {
    private static PrivateKey getPrivateKeyByKeyStore(String keyStorePath, String keystore_password, String alias, String ca_password) throws Exception {
        KeyStore ks = CertificateCoder.getKeyStore(keyStorePath, keystore_password);
        return (PrivateKey)ks.getKey(alias, ca_password.toCharArray());
    }

    private static PublicKey getPublicKeyByCertificate(String certificatePath) throws Exception {
        Certificate certificate = CertificateCoder.getCertificateByFilePath(certificatePath);
        return certificate.getPublicKey();
    }

    private static Certificate getCertificateByKeyStore(String keyStorePath, String keystore_password, String alias) throws Exception {
        KeyStore ks = CertificateCoder.getKeyStore(keyStorePath, keystore_password);
        return ks.getCertificate(alias);
    }

    private static Certificate getCertificateByFilePath(String certificatePath) throws Exception {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("x.509");
        FileInputStream in = new FileInputStream(certificatePath);
        Certificate certificate = certificateFactory.generateCertificate(in);
        in.close();
        return certificate;
    }

    private static KeyStore getKeyStore(String keyStorePath, String keystore_password) throws Exception {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream is = new FileInputStream(keyStorePath);
        ks.load(is, keystore_password.toCharArray());
        is.close();
        return ks;
    }

    public static byte[] encryptByPriateKey(String keyStorePath, String keystore_password, String alias, String ca_password, byte[] data) throws Exception {
        PrivateKey privateKey = CertificateCoder.getPrivateKeyByKeyStore(keyStorePath, keystore_password, alias, ca_password);
        Cipher cipher = Cipher.getInstance(privateKey.getAlgorithm());
        cipher.init(1, privateKey);
        return cipher.doFinal(data);
    }

    public static byte[] decryptByPrivateKey(String keyStorePath, String keystore_password, String alias, String ca_password, byte[] data) throws Exception {
        PrivateKey privateKey = CertificateCoder.getPrivateKeyByKeyStore(keyStorePath, keystore_password, alias, ca_password);
        Cipher cipher = Cipher.getInstance(privateKey.getAlgorithm());
        cipher.init(2, privateKey);
        return cipher.doFinal(data);
    }

    public static byte[] encryptByPublicKey(String certificatePath, byte[] data) throws Exception {
        PublicKey publicKey = CertificateCoder.getPublicKeyByCertificate(certificatePath);
        Cipher cipher = Cipher.getInstance(publicKey.getAlgorithm());
        cipher.init(1, publicKey);
        return cipher.doFinal(data);
    }

    public static byte[] decryptByPublicKey(String certificatePath, byte[] data) throws Exception {
        PublicKey publicKey = CertificateCoder.getPublicKeyByCertificate(certificatePath);
        Cipher cipher = Cipher.getInstance(publicKey.getAlgorithm());
        cipher.init(2, publicKey);
        return cipher.doFinal(data);
    }

    public static byte[] sign(String keyStorePath, String keystore_password, String alias, String ca_password, byte[] sign) throws Exception {
        X509Certificate x509Certificate = (X509Certificate)CertificateCoder.getCertificateByKeyStore(keyStorePath, keystore_password, alias);
        Signature signature = Signature.getInstance(x509Certificate.getSigAlgName());
        PrivateKey privateKey = CertificateCoder.getPrivateKeyByKeyStore(keyStorePath, keystore_password, alias, ca_password);
        signature.initSign(privateKey);
        signature.update(sign);
        return signature.sign();
    }

    public static boolean verify(String certificatePath, byte[] data, byte[] sign) throws Exception {
        X509Certificate x509Certificate = (X509Certificate)CertificateCoder.getCertificateByFilePath(certificatePath);
        Signature signature = Signature.getInstance(x509Certificate.getSigAlgName());
        signature.initVerify(x509Certificate);
        signature.update(data);
        return signature.verify(sign);
    }
}

