/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.cert;

import cn.net.wanmo.common.cert.X500NameUtil;
import cn.net.wanmo.common.codec.CodecUtil;
import cn.net.wanmo.common.security.gm.Sm2Util;
import cn.net.wanmo.common.util.Exceptions;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.asn1.misc.NetscapeCertType;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jcajce.provider.asymmetric.x509.CertificateFactory;
import org.bouncycastle.jce.X509KeyUsage;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.encoders.Base64;

public class Sm2CertUtil {
    public static DERSequence extendedKeyUsage() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)KeyPurposeId.id_kp_clientAuth);
        vector.add((ASN1Encodable)KeyPurposeId.id_kp_emailProtection);
        return new DERSequence(vector);
    }

    public static void makeCertFile(X509Certificate x509Certificate, Path savePath) {
        try {
            if (Files.exists(savePath, new LinkOption[0])) {
                Files.deleteIfExists(savePath);
            }
            Files.createFile(savePath, new FileAttribute[0]);
            System.out.println("savePath: " + savePath.toAbsolutePath().toString());
            byte[] asn1BinCert = x509Certificate.getEncoded();
            byte[] base64EncodedCert = Base64.encode((byte[])asn1BinCert);
            Files.write(savePath, base64EncodedCert, new OpenOption[0]);
        }
        catch (Exception e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    public static void createCertFile(PrivateKey privateKey, PublicKey publickey, X500Name subject, String filePath, String fileName) {
        X500Name issuer = X500NameUtil.getIssuerSM2();
        Date notBefore = new Date();
        Date notAfter = new Date(System.currentTimeMillis() + 1471228928L);
        Sm2CertUtil.createCertFile(privateKey, publickey, issuer, subject, notBefore, notAfter, filePath, fileName);
    }

    public static void createCertFile(PrivateKey privateKey, PublicKey publickey, X500Name issuer, X500Name subject, Date notBefore, Date notAfter, String filePath, String fileName) {
        try {
            JcaContentSignerBuilder jcaContentSB = new JcaContentSignerBuilder("SM3withSM2");
            jcaContentSB.setProvider(Sm2Util.provider);
            ContentSigner sigGen = jcaContentSB.build(privateKey);
            BigInteger sn = BigInteger.valueOf(System.currentTimeMillis());
            JcaX509v3CertificateBuilder jcaX509v3Cert = new JcaX509v3CertificateBuilder(issuer, sn, notBefore, notAfter, subject, publickey);
            jcaX509v3Cert.addExtension(Extension.keyUsage, false, (ASN1Encodable)new X509KeyUsage(192));
            jcaX509v3Cert.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)Sm2CertUtil.extendedKeyUsage());
            jcaX509v3Cert.addExtension(MiscObjectIdentifiers.netscapeCertType, false, (ASN1Encodable)new NetscapeCertType(128));
            JcaX509v3CertificateBuilder x509v3Cert = jcaX509v3Cert;
            X509Certificate certificate = new JcaX509CertificateConverter().setProvider(Sm2Util.provider).getCertificate(x509v3Cert.build(sigGen));
            Sm2CertUtil.makeCertFile(certificate, Paths.get(filePath, fileName));
        }
        catch (Exception e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    public static boolean verifyWithCertFile(String sm2CertFilePath, String data, String signValue) {
        File sm2CertFile = new File(sm2CertFilePath);
        return Sm2CertUtil.verifyWithCertFile(sm2CertFile, data, signValue);
    }

    public static boolean verifyWithCertFile(File sm2CertFile, String data, String signValue) {
        try {
            byte[] bytes = Files.readAllBytes(sm2CertFile.toPath());
            return Sm2CertUtil.verifyWithCertBase64(new String(bytes), data, signValue);
        }
        catch (Exception e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    public static boolean verifyWithCertBase64(String sm2CertBase64, String data, String signValue) {
        try {
            CertificateFactory factory = new CertificateFactory();
            X509Certificate certificate = (X509Certificate)factory.engineGenerateCertificate((InputStream)new ByteArrayInputStream(Base64.decode((String)sm2CertBase64)));
            Signature signature = Signature.getInstance(certificate.getSigAlgName(), Sm2Util.provider);
            signature.initVerify(certificate);
            signature.update(data.getBytes());
            return signature.verify(CodecUtil.decodeHex((String)signValue));
        }
        catch (Exception e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }
}

