/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.cert;

import cn.net.wanmo.common.cert.CertOption;
import cn.net.wanmo.common.util.StringUtil;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;

public class X500NameUtil {
    public static final String RSA = "RSA";
    public static final String SM2 = "SM2";

    public static X500Name createX500Name(CertOption option) {
        X500NameBuilder builder = new X500NameBuilder(BCStyle.INSTANCE);
        if (StringUtil.isNotBlank((CharSequence)option.getC())) {
            builder.addRDN(BCStyle.C, option.getC());
        }
        if (StringUtil.isNotBlank((CharSequence)option.getS())) {
            builder.addRDN(BCStyle.ST, option.getS());
        }
        if (StringUtil.isNotBlank((CharSequence)option.getL())) {
            builder.addRDN(BCStyle.L, option.getL());
        }
        if (StringUtil.isNotBlank((CharSequence)option.getO())) {
            builder.addRDN(BCStyle.O, option.getO());
        }
        if (StringUtil.isNotBlank((CharSequence)option.getCn())) {
            builder.addRDN(BCStyle.CN, option.getCn());
        }
        if (StringUtil.isNotBlank((CharSequence)option.getOu())) {
            builder.addRDN(BCStyle.OU, option.getOu());
        }
        if (StringUtil.isNotBlank((CharSequence)option.getDescription())) {
            builder.addRDN(BCStyle.DESCRIPTION, option.getDescription());
        }
        X500Name subject = builder.build();
        return subject;
    }

    public static X500Name getIssuerRSA() {
        return X500NameUtil.getIssuer(RSA);
    }

    public static X500Name getIssuerSM2() {
        return X500NameUtil.getIssuer(SM2);
    }

    public static X500Name getIssuer(String description) {
        CertOption option = new CertOption();
        option.setS("Shan Xi");
        option.setL("TaiYuan");
        option.setO("WanMo\uff0cInc.");
        option.setO("WanMo Digital Certificate Authority");
        option.setCn("WanMo CA");
        option.setDescription(description);
        return X500NameUtil.createX500Name(option);
    }

    public static X500Name getSubjectForOrganizationRSA(String o, String ou) {
        return X500NameUtil.getSubjectForOrganization(o, ou, RSA);
    }

    public static X500Name getSubjectForOrganizationSM2(String o, String ou) {
        return X500NameUtil.getSubjectForOrganization(o, ou, SM2);
    }

    public static X500Name getSubjectForOrganization(String o, String ou, String description) {
        return X500NameUtil.getSubjectForOrganization(o, ou, null, description);
    }

    public static X500Name getSubjectForOrganizationRSA(String o, String ou, String g) {
        return X500NameUtil.getSubjectForOrganization(o, ou, g, RSA);
    }

    public static X500Name getSubjectForOrganizationSM2(String o, String ou, String g) {
        return X500NameUtil.getSubjectForOrganization(o, ou, g, SM2);
    }

    public static X500Name getSubjectForOrganization(String o, String ou, String g, String description) {
        CertOption option = new CertOption();
        option.setS("ShanXi");
        option.setL("TaiYuan");
        option.setO(o);
        option.setOu(ou);
        option.setG(g);
        option.setDescription(description);
        return X500NameUtil.createX500Name(option);
    }

    public static X500Name getSubjectForPersonRSA(String cn, String ou) {
        return X500NameUtil.getSubjectForPerson(cn, ou, RSA);
    }

    public static X500Name getSubjectForPersonSM2(String cn, String ou) {
        return X500NameUtil.getSubjectForPerson(cn, ou, SM2);
    }

    public static X500Name getSubjectForPerson(String cn, String ou, String description) {
        return X500NameUtil.getSubjectForPerson(cn, ou, null, description);
    }

    public static X500Name getSubjectForPersonRSA(String cn, String ou, String g) {
        return X500NameUtil.getSubjectForPerson(cn, ou, g, RSA);
    }

    public static X500Name getSubjectForPersonSM2(String cn, String ou, String g) {
        return X500NameUtil.getSubjectForPerson(cn, ou, g, SM2);
    }

    public static X500Name getSubjectForPerson(String cn, String ou, String g, String description) {
        CertOption option = new CertOption();
        option.setS("ShanXi");
        option.setL("TaiYuan");
        option.setCn(cn);
        option.setOu(ou);
        option.setG(g);
        option.setDescription(description);
        return X500NameUtil.createX500Name(option);
    }
}

