/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.compress;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.CompressionLevel;
import net.lingala.zip4j.model.enums.EncryptionMethod;

public class Zip4jUtil {
    public static void compressFile(File sourceFile, File descZipFile) throws IOException {
        Zip4jUtil.compressFile(sourceFile, descZipFile, null);
    }

    public static void compressFile(File sourceFile, File descZipFile, String password) throws IOException {
        ZipFile zipFile = Zip4jUtil.getZipFile(descZipFile, password);
        ZipParameters zipParameters = Zip4jUtil.getZipParameters(password);
        Zip4jUtil.compressFile(sourceFile, zipFile, zipParameters);
    }

    public static void compressFile(File sourceFile, ZipFile zipFile, ZipParameters zipParameters) throws IOException {
        zipFile.addFile(sourceFile, zipParameters);
        zipFile.close();
    }

    public static void compressFiles(List<File> sourceFiles, File descZipFile) throws IOException {
        Zip4jUtil.compressFiles(sourceFiles, descZipFile, null);
    }

    public static void compressFiles(List<File> sourceFiles, File descZipFile, String password) throws IOException {
        ZipFile zipFile = Zip4jUtil.getZipFile(descZipFile, password);
        ZipParameters zipParameters = Zip4jUtil.getZipParameters(password);
        Zip4jUtil.compressFiles(sourceFiles, zipFile, zipParameters);
    }

    public static void compressFiles(List<File> sourceFiles, ZipFile zipFile, ZipParameters zipParameters) throws IOException {
        zipFile.addFiles(sourceFiles, zipParameters);
        zipFile.close();
    }

    public static void compressFilesSplit(List<File> sourceFiles, File descZipFile, int splitLength) throws IOException {
        Zip4jUtil.compressFilesSplit(sourceFiles, descZipFile, null, splitLength);
    }

    public static void compressFilesSplit(List<File> sourceFiles, File descZipFile, String password, int splitLength) throws IOException {
        ZipFile zipFile = Zip4jUtil.getZipFile(descZipFile, password);
        ZipParameters zipParameters = Zip4jUtil.getZipParameters(password);
        Zip4jUtil.compressFilesSplit(sourceFiles, zipFile, zipParameters, splitLength);
    }

    public static void compressFilesSplit(List<File> sourceFiles, ZipFile zipFile, ZipParameters zipParameters, int splitLength) throws IOException {
        zipFile.createSplitZipFile(sourceFiles, zipParameters, true, (long)splitLength);
        zipFile.close();
    }

    public static void compressDir(File sourceDir, File descZipFile) throws IOException {
        Zip4jUtil.compressDir(sourceDir, descZipFile, null);
    }

    public static void compressDir(File sourceDir, File descZipFile, String password) throws IOException {
        ZipFile zipFile = Zip4jUtil.getZipFile(descZipFile, password);
        ZipParameters zipParameters = Zip4jUtil.getZipParameters(password);
        Zip4jUtil.compressDir(sourceDir, zipFile, zipParameters);
    }

    public static void compressDir(File sourceDir, ZipFile zipFile, ZipParameters zipParameters) throws IOException {
        zipFile.addFolder(sourceDir, zipParameters);
        zipFile.close();
    }

    public static void compressDirSplit(File sourceDir, File descZipFile, int splitLength) throws IOException {
        Zip4jUtil.compressDirSplit(sourceDir, descZipFile, null, splitLength);
    }

    public static void compressDirSplit(File sourceDir, File descZipFile, String password, int splitLength) throws IOException {
        ZipFile zipFile = Zip4jUtil.getZipFile(descZipFile, password);
        ZipParameters zipParameters = Zip4jUtil.getZipParameters(password);
        Zip4jUtil.compressDirSplit(sourceDir, zipFile, zipParameters, splitLength);
    }

    public static void compressDirSplit(File sourceDir, ZipFile zipFile, ZipParameters zipParameters, int splitLength) throws IOException {
        zipFile.createSplitZipFileFromFolder(sourceDir, zipParameters, true, (long)splitLength);
        zipFile.close();
    }

    public static void extractFile(String sourceZipFile, String fileName, String destinationPath) throws ZipException {
        Zip4jUtil.extractFile(sourceZipFile, fileName, destinationPath, null);
    }

    public static void extractFile(String sourceZipFile, String fileName, String destinationPath, String password) throws ZipException {
        ZipFile zipFile = password == null || password.trim() == "" ? new ZipFile(sourceZipFile) : new ZipFile(sourceZipFile, password.toCharArray());
        zipFile.extractFile(fileName, destinationPath);
    }

    public static void extractAll(String sourceZipFile, String destinationPath) throws ZipException {
        Zip4jUtil.extractAll(sourceZipFile, destinationPath, null);
    }

    public static void extractAll(String sourceZipFile, String destinationPath, String password) throws ZipException {
        ZipFile zipFile = password == null || password.trim() == "" ? new ZipFile(sourceZipFile) : new ZipFile(sourceZipFile, password.toCharArray());
        zipFile.extractAll(destinationPath);
    }

    private static ZipFile getZipFile(File descZipFile, String password) {
        ZipFile zipFile = password == null || password.trim() == "" ? new ZipFile(descZipFile) : new ZipFile(descZipFile, password.toCharArray());
        return zipFile;
    }

    private static ZipParameters getZipParameters(String password) {
        ZipParameters zipParameters = new ZipParameters();
        if (password == null || password.trim() == "") {
            zipParameters.setEncryptionMethod(EncryptionMethod.NONE);
        } else {
            zipParameters.setEncryptFiles(true);
            zipParameters.setCompressionLevel(CompressionLevel.HIGHER);
            zipParameters.setEncryptionMethod(EncryptionMethod.ZIP_STANDARD);
        }
        return zipParameters;
    }
}

