/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.compress;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class ApacheUtil {
    public static void gzipCompress(File inputFile, File outputFile) throws IOException {
        try (FileInputStream fis = new FileInputStream(inputFile);
             GzipCompressorOutputStream gzos = new GzipCompressorOutputStream((OutputStream)new FileOutputStream(outputFile));){
            IOUtils.copy((InputStream)fis, (OutputStream)gzos);
        }
    }

    public static void gzipDecompress(File inputFile, File outputFile) throws IOException {
        try (GzipCompressorInputStream gzis = new GzipCompressorInputStream((InputStream)new FileInputStream(inputFile));
             FileOutputStream fos = new FileOutputStream(outputFile);){
            IOUtils.copy((InputStream)gzis, (OutputStream)fos);
        }
    }

    public static void tarCompress(File[] inputFiles, File outputFile) throws IOException {
        try (TarArchiveOutputStream taros = new TarArchiveOutputStream((OutputStream)new FileOutputStream(outputFile));){
            taros.setLongFileMode(2);
            for (File inputFile : inputFiles) {
                TarArchiveEntry entry = taros.createArchiveEntry(inputFile, inputFile.getName());
                taros.putArchiveEntry(entry);
                try (FileInputStream fis = new FileInputStream(inputFile);){
                    IOUtils.copy((InputStream)fis, (OutputStream)taros);
                }
                taros.closeArchiveEntry();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void tarDecompress(File inputFile, File outputDir) throws IOException {
        try (TarArchiveInputStream taris = new TarArchiveInputStream((InputStream)new FileInputStream(inputFile));){
            TarArchiveEntry entry;
            while ((entry = taris.getNextEntry()) != null) {
                FileOutputStream fos;
                block23: {
                    String fileName = entry.getName();
                    File outputFile = new File(outputDir, fileName);
                    if (entry.isDirectory()) {
                        outputFile.mkdirs();
                        continue;
                    }
                    fos = new FileOutputStream(outputFile);
                    Throwable throwable = null;
                    try {
                        IOUtils.copy((InputStream)taris, (OutputStream)fos);
                        if (fos == null) continue;
                        if (throwable == null) break block23;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (fos == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    fos.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            fos.close();
                            throw throwable3;
                        }
                    }
                    try {
                        fos.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                fos.close();
            }
            return;
        }
    }

    public static void main(String[] args) {
        try {
            File inputFile = new File("input.txt");
            File gzipFile = new File("output.gz");
            File outputFile = new File("output.txt");
            File[] tarInputFiles = new File[]{new File("file1.txt"), new File("file2.txt")};
            File tarFile = new File("output.tar");
            ApacheUtil.gzipCompress(inputFile, gzipFile);
            ApacheUtil.gzipDecompress(gzipFile, outputFile);
            ApacheUtil.tarCompress(tarInputFiles, tarFile);
            ApacheUtil.tarDecompress(tarFile, new File("outputDir"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

