/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.exec;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.exec.OS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeUtil {
    private static Logger logger = LoggerFactory.getLogger(RuntimeUtil.class);

    public static R exec(String command) {
        return RuntimeUtil.exec(command, false);
    }

    public static R exec(String command, boolean isWait) {
        R r = new R();
        try {
            logger.debug("============================= \u6267\u884c\u6307\u4ee4\u5f00\u59cb ===============================");
            logger.debug("\u6267\u884c\u6307\u4ee4\uff1a{}", (Object)command);
            Process process = Runtime.getRuntime().exec(command);
            r = RuntimeUtil.getProcessR(process, isWait);
        }
        catch (Exception e) {
            r.setExceptionStr(e.getMessage());
            logger.error("\u6267\u884c\u6307\u4ee4\u5f02\u5e38", (Throwable)e);
        }
        return r;
    }

    public static R exec(String[] commands) {
        return RuntimeUtil.exec(commands, false);
    }

    public static R exec(String[] commands, boolean isWait) {
        R r = new R();
        try {
            logger.debug("============================= \u6267\u884c\u6307\u4ee4\u5f00\u59cb ===============================");
            logger.debug("\u6267\u884c\u6307\u4ee4\uff1a{}", Arrays.asList(commands));
            Process process = Runtime.getRuntime().exec(commands);
            r = RuntimeUtil.getProcessR(process, isWait);
        }
        catch (Exception e) {
            r.setExceptionStr(e.getMessage());
            logger.error("\u6267\u884c\u6307\u4ee4\u5f02\u5e38", (Throwable)e);
        }
        return r;
    }

    public static R getProcessR(Process process, boolean isWait) {
        String exceptionStr;
        String errorStr;
        R r = new R();
        try {
            if (isWait) {
                int waitFor = process.waitFor();
                r.setWaitFor(waitFor);
            }
            r.setInputStr(RuntimeUtil.getStreamStr(process.getInputStream()));
            r.setErrorStr(RuntimeUtil.getStreamStr(process.getErrorStream()));
            r.setExitValue(process.exitValue());
            process.destroy();
        }
        catch (Exception e) {
            r.setExceptionStr(e.getMessage());
            logger.error("\u6267\u884c\u6307\u4ee4\u5f02\u5e38", (Throwable)e);
        }
        logger.debug("\u6267\u884c\u6307\u4ee4 waitFor \u4ee3\u7801\uff1a{}", (Object)r.getWaitFor());
        logger.debug("\u6267\u884c\u6307\u4ee4 exitValue \u4ee3\u7801\uff1a{}", (Object)r.getExitValue());
        String inputStr = r.getInputStr();
        if (inputStr != null && inputStr.trim() != "" && inputStr.trim().length() > 0) {
            logger.debug("\u6267\u884c\u6307\u4ee4\u6b63\u5e38\u8f93\u51fa\uff1a\r\n {}", (Object)inputStr);
        }
        if ((errorStr = r.getErrorStr()) != null && errorStr.trim() != "" && errorStr.trim().length() > 0) {
            logger.debug("\u6267\u884c\u6307\u4ee4\u8b66\u544a\u6216\u9519\u8bef\uff1a\r\n {}", (Object)errorStr);
        }
        if ((exceptionStr = r.getExceptionStr()) != null && exceptionStr.trim() != "" && exceptionStr.trim().length() > 0) {
            logger.debug("\u6267\u884c\u6307\u4ee4\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)exceptionStr);
        }
        logger.debug("============================= \u6267\u884c\u6307\u4ee4\u7ed3\u675f ===============================");
        return r;
    }

    public static String getStreamStr(InputStream is) {
        Charset charset = StandardCharsets.UTF_8;
        if (OS.isFamilyWindows()) {
            charset = Charset.forName("GBK");
        }
        return RuntimeUtil.getStreamStr(is, charset);
    }

    public static String getStreamStr(InputStream is, Charset charset) {
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is, charset));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                is.close();
                br.close();
            }
            catch (Exception exception) {}
        }
    }

    public static class R {
        private int waitFor;
        private String inputStr;
        private String errorStr;
        private int exitValue;
        private String exceptionStr;

        public R() {
        }

        public R(int waitFor, String inputStr, String errorStr) {
            this.waitFor = waitFor;
            this.inputStr = inputStr;
            this.errorStr = errorStr;
        }

        public R(String inputStr, String errorStr, int exitValue) {
            this.inputStr = inputStr;
            this.errorStr = errorStr;
            this.exitValue = exitValue;
        }

        public R(int waitFor, String inputStr, String errorStr, int exitValue) {
            this.waitFor = waitFor;
            this.inputStr = inputStr;
            this.errorStr = errorStr;
            this.exitValue = exitValue;
        }

        public int getWaitFor() {
            return this.waitFor;
        }

        public void setWaitFor(int waitFor) {
            this.waitFor = waitFor;
        }

        public String getInputStr() {
            return this.inputStr;
        }

        public void setInputStr(String inputStr) {
            this.inputStr = inputStr;
        }

        public String getErrorStr() {
            return this.errorStr;
        }

        public void setErrorStr(String errorStr) {
            this.errorStr = errorStr;
        }

        public int getExitValue() {
            return this.exitValue;
        }

        public void setExitValue(int exitValue) {
            this.exitValue = exitValue;
        }

        public boolean isSuccess() {
            return this.exitValue == 0;
        }

        public String getExceptionStr() {
            return this.exceptionStr;
        }

        public void setExceptionStr(String exceptionStr) {
            this.exceptionStr = exceptionStr;
        }
    }
}

