package cn.net.wanmo.common.exec;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProcessBuilderGenerate {
    private static Logger logger = LoggerFactory.getLogger(ProcessBuilderGenerate.class);

    public static ProcessBuilderGenerate build() {
        return new ProcessBuilderGenerate();
    }

    /**
     * 执行指令
     */
    public Process getProcess() throws IOException {
        logger.debug("============================= 执行指令开始 ===============================");
        logger.debug("执行指令：{}", this.command);

        ProcessBuilder processBuilder = new ProcessBuilder();
        processBuilder.command(command);

        if (Objects.nonNull(this.environment) && this.environment.size() > 0) { // 设置环境变量
            for (Map.Entry<String, String> entry : this.environment.entrySet()) {
                processBuilder.environment().put(entry.getKey(), entry.getValue());
            }
        }

        if (Objects.nonNull(this.redirectInputFile) && this.redirectInputFile.exists()) { // 指令执行交互 是否重定向输入
            processBuilder.redirectInput(this.redirectInputFile);
        }
        if (Objects.nonNull(this.redirectOutputFile) && this.redirectOutputFile.exists()) { // 指令执行结果 是否重定向输出
            processBuilder.redirectOutput(this.redirectOutputFile);
        }
        if (Objects.nonNull(this.redirectErrorFile) && this.redirectErrorFile.exists()) { // 指令执行警告或错误 是否重定向输出
            processBuilder.redirectError(this.redirectErrorFile);
        }

        return processBuilder.start();
    }

    /**
     * 执行指令
     */
    public R exec() {
        R r = new R();
        try {
            Process process = getProcess();
            r = ProcessUtil.getProcessR(process, this.isWait);
        } catch (Exception e) {
            r.setExceptionStr(e.getMessage());
            logger.error("执行指令异常", e);
        }
        return r;
    }

    /**
     * 指令
     */
    private List<String> command;
    /**
     * 是否等待，默认 false
     */
    private boolean isWait = false;
    /**
     * 环境变量
     */
    private Map<String, String> environment = new HashMap<>();
    /**
     * 重定向输入：传递给指令的参数
     */
    private File redirectInputFile;
    /**
     * 重定向输出：指令的执行结果
     */
    private File redirectOutputFile;
    /**
     * 重定向错误：指令执行的警告或错误
     */
    private File redirectErrorFile;

    public List<String> getCommand() {
        return command;
    }

    public ProcessBuilderGenerate setCommand(List<String> command) {
        this.command = command;
        return this;
    }

    public boolean isWait() {
        return isWait;
    }

    public ProcessBuilderGenerate setWait(boolean wait) {
        isWait = wait;
        return this;
    }

    public Map<String, String> getEnvironment() {
        return environment;
    }

    public ProcessBuilderGenerate setEnvironment(Map<String, String> environment) {
        this.environment = environment;
        return this;
    }

    public ProcessBuilderGenerate putEnvironment(String key, String value) {
        this.environment.put(key, value);
        return this;
    }

    public File getRedirectInputFile() {
        return redirectInputFile;
    }

    public ProcessBuilderGenerate setRedirectInputFile(File redirectInputFile) {
        this.redirectInputFile = redirectInputFile;
        return this;
    }

    public File getRedirectOutputFile() {
        return redirectOutputFile;
    }

    public ProcessBuilderGenerate setRedirectOutputFile(File redirectOutputFile) {
        this.redirectOutputFile = redirectOutputFile;
        return this;
    }

    public File getRedirectErrorFile() {
        return redirectErrorFile;
    }

    public ProcessBuilderGenerate setRedirectErrorFile(File redirectErrorFile) {
        this.redirectErrorFile = redirectErrorFile;
        return this;
    }
}
