package cn.net.wanmo.common.exec;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;
import java.util.List;

/**
 * 命令行执行工具类 <br/>
 * cmd /c dir：执行完dir命令后关闭命令窗口； <br/>
 * cmd /k dir：执行完dir命令后不关闭命令窗口。 <br/>
 * cmd /c start dir：会打开一个新窗口后执行dir指令，原窗口会关闭； <br/>
 * cmd /k start dir：会打开一个新窗口后执行dir指令，原窗口不会关闭。 <br/>
 */
public class RuntimeGenerate {
    private static Logger logger = LoggerFactory.getLogger(RuntimeGenerate.class);


    public static RuntimeGenerate build() {
        return new RuntimeGenerate();
    }

    /**
     * 执行指令
     */
    public R exec(String command) {
        R r = new R();
        try {
            logger.debug("============================= 执行指令开始 ===============================");
            logger.debug("执行指令：{}", command);

            final Process process = Runtime.getRuntime().exec(command);
            r = ProcessUtil.getProcessR(process, this.isWait);
        } catch (Exception e) {
            r.setExceptionStr(e.getMessage());
            logger.error("执行指令异常", e);
        }
        return r;
    }

    /**
     * 执行指令
     */
    public R exec(String... commands) {
        R r = new R();
        try {
            logger.debug("============================= 执行指令开始 ===============================");
            logger.debug("执行指令：{}", Arrays.asList(commands));

            final Process process = Runtime.getRuntime().exec(commands);
            r = ProcessUtil.getProcessR(process, this.isWait);
        } catch (Exception e) {
            r.setExceptionStr(e.getMessage());
            logger.error("执行指令异常", e);
        }
        return r;
    }

    /**
     * 执行指令
     */
    public R exec(List<String> commands) {
        String[] commandArray = commands.stream().toArray(String[]::new);
        return exec(commandArray);
    }


    /**
     * 是否等待，默认 false
     */
    private boolean isWait = false;

    public RuntimeGenerate() {
    }

    public boolean isWait() {
        return isWait;
    }

    public RuntimeGenerate setWait(boolean wait) {
        isWait = wait;
        return this;
    }
}
