package cn.net.wanmo.common.exec;

import org.apache.commons.exec.OS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ProcessUtil {
    private static Logger logger = LoggerFactory.getLogger(ProcessUtil.class);

    /**
     * 从进程获取响应数据
     *
     * @param process 进程
     * @param isWait  是否等待
     * @return 响应
     */
    public static R getProcessR(Process process, boolean isWait) {
        R r = new R();
        try {
            if (isWait) {
                final int waitFor = process.waitFor();
                r.setWaitFor(waitFor);
            }

            {
//                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
            }

            {
                r.setInputStr(getStreamStr(process.getInputStream()));
            }

            {
                r.setErrorStr(getStreamStr(process.getErrorStream()));
            }

            r.setExitValue(process.exitValue());

            if (isWait) {
                process.destroy(); // 如果没有开启 isWait，会导致指令未执行完就发起关闭
            }
        } catch (Exception e) {
            r.setExceptionStr(e.getMessage());
            logger.error("执行指令异常", e);
        }

        {
            logger.debug("执行指令 waitFor 代码：{}", r.getWaitFor());
            logger.debug("执行指令 exitValue 代码：{}", r.getExitValue());

            String inputStr = r.getInputStr();
            if (inputStr != null && inputStr.trim() != "" && inputStr.trim().length() > 0) {
                logger.debug("执行指令正常输出：\r\n{}", inputStr);
            }

            String errorStr = r.getErrorStr();
            if (errorStr != null && errorStr.trim() != "" && errorStr.trim().length() > 0) {
                logger.debug("执行指令警告或错误：\r\n{}", errorStr);
            }

            String exceptionStr = r.getExceptionStr();
            if (exceptionStr != null && exceptionStr.trim() != "" && exceptionStr.trim().length() > 0) {
                logger.debug("执行指令异常信息：{}", exceptionStr);
            }
            logger.debug("============================= 执行指令结束 ===============================");
        }

        return r;
    }


    /**
     * 接收的数据流取为字符串
     *
     * @param is 数据流
     * @return 字符串
     */
    public static String getStreamStr(InputStream is) {
        String s = null;
        BufferedReader br = null;
        try {
            Charset charset = StandardCharsets.UTF_8;
            if (OS.isFamilyWindows()) {
                charset = Charset.forName("GBK");
            }

            br = new BufferedReader(new InputStreamReader(is, charset));

            StringBuilder sb = new StringBuilder();
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }

            s = sb.toString();
        } catch (Exception e) {
            logger.error("读取执行结果异常", e);
        } finally {
            try {
                br.close();
                is.close();
            } catch (Exception e) {
            }
        }

        return s;
    }

}
