/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.exec;

import cn.net.wanmo.common.exec.ProcessUtil;
import cn.net.wanmo.common.exec.R;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeGenerate {
    private static Logger logger = LoggerFactory.getLogger(RuntimeGenerate.class);
    private String command;
    private List<String> commands;
    private boolean isWait = false;
    private Map<String, String> envp = new HashMap<String, String>();
    private File dir = null;

    public static RuntimeGenerate build() {
        return new RuntimeGenerate();
    }

    public R exec() {
        R r = new R();
        try {
            if (this.command != null && this.command.trim().length() != 0) {
                r = this.exec(this.command);
            }
            if (this.commands != null && !this.commands.isEmpty()) {
                r = this.exec(this.commands);
            }
        }
        catch (Exception e) {
            r.setExceptionStr(e.getMessage());
            logger.error("\u6267\u884c\u6307\u4ee4\u5f02\u5e38", (Throwable)e);
        }
        return r;
    }

    public R exec(String command) {
        R r = new R();
        try {
            logger.debug("============================= \u6267\u884c\u6307\u4ee4\u5f00\u59cb ===============================");
            logger.debug("\u6267\u884c\u6307\u4ee4\uff1a{}", (Object)command);
            logger.debug("\u73af\u5883\u53d8\u91cf\uff1a{}", this.envp);
            logger.debug("\u5de5\u4f5c\u76ee\u5f55\uff1a{}", (Object)this.dir);
            Process process = Runtime.getRuntime().exec(command, this.toEnvp(), this.dir);
            r = ProcessUtil.getProcessR(process, this.isWait);
        }
        catch (Exception e) {
            r.setExceptionStr(e.getMessage());
            logger.error("\u6267\u884c\u6307\u4ee4\u5f02\u5e38", (Throwable)e);
        }
        return r;
    }

    public R exec(String ... commands) {
        R r = new R();
        try {
            logger.debug("============================= \u6267\u884c\u6307\u4ee4\u5f00\u59cb ===============================");
            logger.debug("\u6267\u884c\u6307\u4ee4\uff1a{}", Arrays.asList(commands));
            logger.debug("\u73af\u5883\u53d8\u91cf\uff1a{}", this.envp);
            logger.debug("\u5de5\u4f5c\u76ee\u5f55\uff1a{}", (Object)this.dir);
            Process process = Runtime.getRuntime().exec(commands, this.toEnvp(), this.dir);
            r = ProcessUtil.getProcessR(process, this.isWait);
        }
        catch (Exception e) {
            r.setExceptionStr(e.getMessage());
            logger.error("\u6267\u884c\u6307\u4ee4\u5f02\u5e38", (Throwable)e);
        }
        return r;
    }

    public R exec(List<String> commands) {
        String[] commandArray = (String[])commands.stream().toArray(String[]::new);
        return this.exec(commandArray);
    }

    public RuntimeGenerate command(String command) {
        this.command = command;
        return this;
    }

    public RuntimeGenerate commands(List<String> commands) {
        this.commands = commands;
        return this;
    }

    public RuntimeGenerate wait(boolean wait) {
        this.isWait = wait;
        return this;
    }

    public RuntimeGenerate envp(Map<String, String> envp) {
        if (envp == null || envp.isEmpty()) {
            return this;
        }
        for (Map.Entry<String, String> entry : envp.entrySet()) {
            this.envp(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public RuntimeGenerate envp(String key, String value) {
        this.envp.put(key, value);
        return this;
    }

    private String[] toEnvp() {
        if (this.envp == null || this.envp.isEmpty()) {
            return null;
        }
        ArrayList<String> envpListTmp = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.envp.entrySet()) {
            String s = entry.getKey() + "=" + entry.getValue();
            envpListTmp.add(s);
        }
        String[] envpArrTmp = (String[])envpListTmp.stream().toArray(String[]::new);
        return envpArrTmp;
    }

    public RuntimeGenerate dir(File dir) {
        this.dir = dir;
        return this;
    }
}

