package cn.net.wanmo.common.exec;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.util.*;

/**
 * 命令行执行工具类 <br/>
 * cmd /c dir：执行完dir命令后关闭命令窗口； <br/>
 * cmd /k dir：执行完dir命令后不关闭命令窗口。 <br/>
 * cmd /c start dir：会打开一个新窗口后执行dir指令，原窗口会关闭； <br/>
 * cmd /k start dir：会打开一个新窗口后执行dir指令，原窗口不会关闭。 <br/>
 */
public class RuntimeGenerate {
    private static Logger logger = LoggerFactory.getLogger(RuntimeGenerate.class);


    public static RuntimeGenerate build() {
        return new RuntimeGenerate();
    }


    /**
     * 执行指令
     */
    public R exec() {
        R r = new R();
        try {
            if (this.command == null || this.command.trim().length() == 0) {
            } else {
                r = exec(this.command);
            }

            if (this.commands == null || this.commands.isEmpty()) {
            } else {
                r = exec(this.commands);
            }
        } catch (Exception e) {
            r.setExceptionStr(e.getMessage());
            logger.error("执行指令异常", e);
        }
        return r;
    }

    /**
     * 执行指令
     */
    public R exec(String command) {
        R r = new R();
        try {
            logger.debug("============================= 执行指令开始 ===============================");
            logger.debug("执行指令：{}", command);
            logger.debug("环境变量：{}", this.envp);
            logger.debug("工作目录：{}", this.dir);

            final Process process = Runtime.getRuntime().exec(command, toEnvp(), this.dir);
            r = ProcessUtil.getProcessR(process, this.isWait);
        } catch (Exception e) {
            r.setExceptionStr(e.getMessage());
            logger.error("执行指令异常", e);
        }
        return r;
    }

    /**
     * 执行指令
     */
    public R exec(String... commands) {
        R r = new R();
        try {
            logger.debug("============================= 执行指令开始 ===============================");
            logger.debug("执行指令：{}", Arrays.asList(commands));
            logger.debug("环境变量：{}", this.envp);
            logger.debug("工作目录：{}", this.dir);

            final Process process = Runtime.getRuntime().exec(commands, toEnvp(), this.dir);

            r = ProcessUtil.getProcessR(process, this.isWait);
        } catch (Exception e) {
            r.setExceptionStr(e.getMessage());
            logger.error("执行指令异常", e);
        }
        return r;
    }

    /**
     * 执行指令
     */
    public R exec(List<String> commands) {
        String[] commandArray = commands.stream().toArray(String[]::new);
        return exec(commandArray);
    }

    /**
     * 指令
     */
    private String command;

    /**
     * 指令
     */
    private List<String> commands;

    /**
     * 是否等待，默认 false
     */
    private boolean isWait = false;

    /**
     * 环境变量
     */
    private Map<String, String> envp = new HashMap<>();

    /**
     * 子进程的工作目录，如果子进程应该继承当前进程的工作目录，则该参数为 null
     */
    private File dir = null;

    public RuntimeGenerate() {
    }

    public RuntimeGenerate command(String command) {
        this.command = command;
        return this;
    }

    public RuntimeGenerate commands(List<String> commands) {
        this.commands = commands;
        return this;
    }

    /**
     * 是否等待
     *
     * @param wait 是否等待
     * @return 对象
     */
    public RuntimeGenerate wait(boolean wait) {
        isWait = wait;
        return this;
    }

    /**
     * 设置环境变量
     *
     * @param envp 环境变量
     * @return 对象
     */
    public RuntimeGenerate envp(Map<String, String> envp) {
        if (envp == null || envp.isEmpty()) {
            return this;
        }

        for (Map.Entry<String, String> entry : envp.entrySet()) {
            envp(entry.getKey(), entry.getValue());
        }
        return this;
    }

    /**
     * 设置环境变量
     *
     * @param key   变量key
     * @param value 变量value
     * @return 对象
     */
    public RuntimeGenerate envp(String key, String value) {
        this.envp.put(key, value);
        return this;
    }

    /**
     * 字符串数组，其中每个元素的环境变量的设置格式为 name=value，如果子进程应该继承当前进程的环境，或该参数为 null
     *
     * @return 环境变量
     */
    private String[] toEnvp() {
        if (this.envp == null || this.envp.isEmpty()) {
            return null;
        }

        List<String> envpListTmp = new ArrayList<>();
        for (Map.Entry<String, String> entry : this.envp.entrySet()) {
            String s = entry.getKey() + "=" + entry.getValue();
            envpListTmp.add(s);
        }
        String[] envpArrTmp = envpListTmp.stream().toArray(String[]::new);

        return envpArrTmp;
    }

    /**
     * 子进程的工作目录，如果子进程应该继承当前进程的工作目录，则该参数为 null
     */
    public RuntimeGenerate dir(File dir) {
        this.dir = dir;
        return this;
    }
}
