/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.exec;

import cn.net.wanmo.common.exec.ProcessUtil;
import cn.net.wanmo.common.exec.R;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessBuilderGenerate {
    private static Logger logger = LoggerFactory.getLogger(ProcessBuilderGenerate.class);
    private List<String> commands = new ArrayList<String>();
    private boolean isWait = false;
    private Map<String, String> environment = new HashMap<String, String>();
    private File redirectInputFile;
    private File redirectOutputFile;
    private File redirectErrorFile;

    public static ProcessBuilderGenerate build() {
        return new ProcessBuilderGenerate();
    }

    public Process getProcess() throws IOException {
        logger.debug("============================= \u6267\u884c\u6307\u4ee4\u5f00\u59cb ===============================");
        logger.debug("\u6267\u884c\u6307\u4ee4\uff1a{}", this.commands);
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(this.commands);
        if (Objects.nonNull(this.environment) && this.environment.size() > 0) {
            for (Map.Entry<String, String> entry : this.environment.entrySet()) {
                processBuilder.environment().put(entry.getKey(), entry.getValue());
            }
        }
        if (Objects.nonNull(this.redirectInputFile)) {
            processBuilder.redirectInput(this.redirectInputFile);
        }
        if (Objects.nonNull(this.redirectOutputFile)) {
            processBuilder.redirectOutput(this.redirectOutputFile);
        }
        if (Objects.nonNull(this.redirectErrorFile)) {
            processBuilder.redirectError(this.redirectErrorFile);
        }
        return processBuilder.start();
    }

    public R exec() {
        R r = new R();
        try {
            Process process = this.getProcess();
            r = ProcessUtil.getProcessR(process, this.isWait);
        }
        catch (Exception e) {
            r.setExceptionStr(e.getMessage());
            logger.error("\u6267\u884c\u6307\u4ee4\u5f02\u5e38", (Throwable)e);
        }
        return r;
    }

    public ProcessBuilderGenerate commands(List<String> commands) {
        this.commands = commands;
        return this;
    }

    public ProcessBuilderGenerate wait(boolean wait) {
        this.isWait = wait;
        return this;
    }

    public ProcessBuilderGenerate putEnv(String key, String value) {
        this.environment.put(key, value);
        return this;
    }

    public ProcessBuilderGenerate redirectInputFile(File redirectInputFile) {
        this.redirectInputFile = redirectInputFile;
        return this;
    }

    public ProcessBuilderGenerate redirectOutputFile(File redirectOutputFile) {
        this.redirectOutputFile = redirectOutputFile;
        return this;
    }

    public ProcessBuilderGenerate redirectErrorFile(File redirectErrorFile) {
        this.redirectErrorFile = redirectErrorFile;
        return this;
    }
}

