/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.exec;

import cn.net.wanmo.common.exec.R;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.exec.OS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtil {
    private static Logger logger = LoggerFactory.getLogger(ProcessUtil.class);

    public static R getProcessR(Process process, boolean isWait) {
        String exceptionStr;
        String errorStr;
        R r = new R();
        try {
            if (isWait) {
                int waitFor = process.waitFor();
                r.setWaitFor(waitFor);
            }
            r.setInputStr(ProcessUtil.getStreamStr(process.getInputStream()));
            r.setErrorStr(ProcessUtil.getStreamStr(process.getErrorStream()));
            r.setExitValue(process.exitValue());
            if (isWait) {
                process.destroy();
            }
        }
        catch (Exception e) {
            r.setExceptionStr(e.getMessage());
            logger.error("\u6267\u884c\u6307\u4ee4\u5f02\u5e38", (Throwable)e);
        }
        logger.debug("\u6267\u884c\u6307\u4ee4 waitFor \u4ee3\u7801\uff1a{}", (Object)r.getWaitFor());
        logger.debug("\u6267\u884c\u6307\u4ee4 exitValue \u4ee3\u7801\uff1a{}", (Object)r.getExitValue());
        String inputStr = r.getInputStr();
        if (inputStr != null && inputStr.trim() != "" && inputStr.trim().length() > 0) {
            logger.debug("\u6267\u884c\u6307\u4ee4\u6b63\u5e38\u8f93\u51fa\uff1a\r\n{}", (Object)inputStr);
        }
        if ((errorStr = r.getErrorStr()) != null && errorStr.trim() != "" && errorStr.trim().length() > 0) {
            logger.debug("\u6267\u884c\u6307\u4ee4\u8b66\u544a\u6216\u9519\u8bef\uff1a\r\n{}", (Object)errorStr);
        }
        if ((exceptionStr = r.getExceptionStr()) != null && exceptionStr.trim() != "" && exceptionStr.trim().length() > 0) {
            logger.debug("\u6267\u884c\u6307\u4ee4\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)exceptionStr);
        }
        logger.debug("============================= \u6267\u884c\u6307\u4ee4\u7ed3\u675f ===============================");
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStreamStr(InputStream is) {
        String s = null;
        BufferedReader br = null;
        try {
            String line;
            Charset charset = StandardCharsets.UTF_8;
            if (OS.isFamilyWindows()) {
                charset = Charset.forName("GBK");
            }
            br = new BufferedReader(new InputStreamReader(is, charset));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            s = sb.toString();
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u6267\u884c\u7ed3\u679c\u5f02\u5e38", (Throwable)e);
        }
        finally {
            try {
                br.close();
                is.close();
            }
            catch (Exception exception) {}
        }
        return s;
    }
}

