/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtil {
    private static Logger logger = LoggerFactory.getLogger(ImageUtil.class);

    public static final String getFormatName(File file) {
        if (!ImageUtil.isImage(file)) {
            return null;
        }
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(file);
            Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
            if (!iter.hasNext()) {
                return null;
            }
            ImageReader reader = iter.next();
            iis.close();
            return reader.getFormatName().toLowerCase();
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6\u56fe\u7247 FormatName \u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static final boolean isImage(File file) {
        boolean flag = false;
        try {
            BufferedImage bufreader = ImageIO.read(file);
            if (bufreader == null) {
                flag = false;
            } else {
                int width = bufreader.getWidth();
                int height = bufreader.getHeight();
                flag = width != 0 && height != 0;
            }
        }
        catch (IOException e) {
            logger.error("\u5224\u65ad\u6587\u4ef6\u662f\u5426\u4e3a\u56fe\u7247\u5f02\u5e38", (Throwable)e);
        }
        return flag;
    }

    public static File resizeWidth(File sourceFile, int scaledWidth) {
        File targetFile = null;
        try {
            targetFile = File.createTempFile("resize", "." + ImageUtil.getSuffix(sourceFile));
            boolean flag = ImageUtil.resize(sourceFile, targetFile, scaledWidth, 0);
            if (!flag && targetFile != null) {
                targetFile.deleteOnExit();
                targetFile = null;
            }
        }
        catch (IOException e) {
            logger.error("\u56fe\u7247\u5206\u8fa8\u7387\u538b\u7f29\u5f02\u5e38", (Throwable)e);
        }
        return targetFile;
    }

    public static File resizeHeight(File sourceFile, int scaledHeight) {
        File targetFile = null;
        try {
            targetFile = File.createTempFile("resize", "." + ImageUtil.getSuffix(sourceFile));
            boolean flag = ImageUtil.resize(sourceFile, targetFile, 0, scaledHeight);
            if (!flag && targetFile != null) {
                targetFile.deleteOnExit();
                targetFile = null;
            }
        }
        catch (IOException e) {
            logger.error("\u56fe\u7247\u5206\u8fa8\u7387\u538b\u7f29\u5f02\u5e38", (Throwable)e);
        }
        return targetFile;
    }

    public static boolean resize(File sourceFile, File targetFile, int scaledWidth, int scaledHeight) {
        try {
            double percentage;
            BufferedImage bufferedImage = ImageIO.read(sourceFile);
            int width = bufferedImage.getWidth();
            int height = bufferedImage.getHeight();
            if (scaledWidth == 0 && scaledHeight == 0) {
                scaledWidth = width;
                scaledHeight = height;
            }
            if (scaledWidth == 0) {
                percentage = (double)scaledHeight * 1.0 / (double)height;
                scaledWidth = Double.valueOf(percentage * (double)width).intValue();
            }
            if (scaledHeight == 0) {
                percentage = (double)scaledWidth * 1.0 / (double)width;
                scaledHeight = Double.valueOf(percentage * (double)height).intValue();
            }
            return ImageUtil.resize(bufferedImage, scaledWidth, scaledHeight, targetFile, ImageUtil.getFormatName(sourceFile));
        }
        catch (IOException e) {
            logger.error("\u56fe\u7247\u5206\u8fa8\u7387\u538b\u7f29\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public static boolean resize(BufferedImage sourceImage, int scaledWidth, int scaledHeight, File targetFile, String formatName) {
        boolean flag = false;
        try {
            Image scaledInstance = sourceImage.getScaledInstance(scaledWidth, scaledHeight, 4);
            BufferedImage targetImage = new BufferedImage(scaledWidth, scaledHeight, sourceImage.getType());
            Graphics graphics = targetImage.getGraphics();
            graphics.drawImage(scaledInstance, 0, 0, null);
            graphics.dispose();
            ImageIO.write((RenderedImage)targetImage, formatName, targetFile);
            flag = true;
        }
        catch (IOException e) {
            logger.error("\u56fe\u7247\u5206\u8fa8\u7387\u538b\u7f29\u5f02\u5e38", (Throwable)e);
        }
        return flag;
    }

    public static File watermarkText(File srcImageFile, String text, int x, int y) {
        File targetFile = null;
        try {
            targetFile = File.createTempFile("watermark", "." + ImageUtil.getSuffix(srcImageFile));
            boolean flag = ImageUtil.watermarkText(srcImageFile, targetFile, text, x, y);
            if (!flag && targetFile != null) {
                targetFile.deleteOnExit();
                targetFile = null;
            }
        }
        catch (IOException e) {
            logger.error("\u6dfb\u52a0\u6587\u5b57\u6c34\u5370\u5f02\u5e38", (Throwable)e);
        }
        return targetFile;
    }

    public static boolean watermarkText(File srcImageFile, File targetFile, String text, int x, int y) {
        boolean flag = false;
        try {
            BufferedImage read = ImageIO.read(srcImageFile);
            Graphics2D graphics = read.createGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 20));
            graphics.setColor(new Color(255, 255, 255));
            graphics.drawString(text, x, y);
            graphics.dispose();
            ImageIO.write((RenderedImage)read, ImageUtil.getFormatName(srcImageFile), targetFile);
            flag = true;
        }
        catch (IOException e) {
            logger.error("\u6dfb\u52a0\u6587\u5b57\u6c34\u5370\u5f02\u5e38", (Throwable)e);
        }
        return flag;
    }

    public static File watermarkImage(File srcImageFile, File waterImage, int x, int y) {
        File targetFile = null;
        try {
            targetFile = File.createTempFile("watermark", "." + ImageUtil.getSuffix(srcImageFile));
            boolean flag = ImageUtil.watermarkImage(srcImageFile, targetFile, waterImage, x, y);
            if (!flag && targetFile != null) {
                targetFile.deleteOnExit();
                targetFile = null;
            }
        }
        catch (IOException e) {
            logger.error("\u6dfb\u52a0\u6587\u5b57\u6c34\u5370\u5f02\u5e38", (Throwable)e);
        }
        return targetFile;
    }

    public static boolean watermarkImage(File srcImageFile, File targetFile, File waterImage, int x, int y) {
        boolean flag = false;
        try {
            BufferedImage read = ImageIO.read(srcImageFile);
            BufferedImage image = ImageIO.read(waterImage);
            Graphics2D graphics = read.createGraphics();
            graphics.setComposite(AlphaComposite.getInstance(10, 0.5f));
            graphics.drawImage((Image)image, x, y, null);
            graphics.dispose();
            ImageIO.write((RenderedImage)read, ImageUtil.getFormatName(srcImageFile), targetFile);
            flag = true;
        }
        catch (IOException e) {
            logger.error("\u6dfb\u52a0\u56fe\u7247\u6c34\u5370\u5f02\u5e38", (Throwable)e);
        }
        return flag;
    }

    public static File cut(File srcImageFile, int x, int y, int width, int height) {
        File targetFile = null;
        try {
            targetFile = File.createTempFile("cut_image", "." + ImageUtil.getSuffix(srcImageFile));
            boolean flag = ImageUtil.cut(srcImageFile, targetFile, x, y, width, height);
            if (!flag && targetFile != null) {
                targetFile.deleteOnExit();
                targetFile = null;
            }
        }
        catch (IOException e) {
            logger.error("\u88c1\u526a\u56fe\u7247\u5f02\u5e38", (Throwable)e);
        }
        return targetFile;
    }

    public static boolean cut(File srcImageFile, File destImageFile, int x, int y, int width, int height) {
        boolean flag = false;
        try {
            BufferedImage read = ImageIO.read(srcImageFile);
            BufferedImage image = read.getSubimage(x, y, width, height);
            ImageIO.write((RenderedImage)image, ImageUtil.getFormatName(srcImageFile), destImageFile);
            flag = true;
        }
        catch (IOException e) {
            logger.error("\u88c1\u526a\u56fe\u7247\u5f02\u5e38", (Throwable)e);
        }
        return flag;
    }

    public static File rotateImage(File sourceImage, double angle) {
        File targetFile = null;
        try {
            targetFile = File.createTempFile("rotate_image", "." + ImageUtil.getSuffix(sourceImage));
            boolean flag = ImageUtil.rotateImage(sourceImage, targetFile, angle);
            if (!flag && targetFile != null) {
                targetFile.deleteOnExit();
                targetFile = null;
            }
        }
        catch (IOException e) {
            logger.error("\u56fe\u7247\u65cb\u8f6c\u5f02\u5e38", (Throwable)e);
        }
        return targetFile;
    }

    public static boolean rotateImage(File sourceImage, File targetImage, double angle) {
        boolean flag = false;
        try {
            BufferedImage bufferedSource = ImageIO.read(sourceImage);
            BufferedImage bufferedTarget = ImageUtil.rotateImage(bufferedSource, angle);
            ImageIO.write((RenderedImage)bufferedTarget, ImageUtil.getFormatName(sourceImage), targetImage);
            flag = true;
        }
        catch (IOException e) {
            logger.error("\u56fe\u7247\u65cb\u8f6c\u5f02\u5e38", (Throwable)e);
        }
        return flag;
    }

    public static BufferedImage rotateImage(BufferedImage image, double angle) {
        return ImageUtil.rotateImage_2(image, angle);
    }

    public static BufferedImage rotateImage_1(BufferedImage image, double angle) {
        AffineTransform transform = new AffineTransform();
        transform.rotate(Math.toRadians(angle), image.getWidth() / 2, image.getHeight() / 2);
        AffineTransformOp op = new AffineTransformOp(transform, 2);
        BufferedImage rotatedImage = op.filter(image, null);
        return rotatedImage;
    }

    public static BufferedImage rotateImage_2(BufferedImage image, double angle) {
        int width = image.getWidth();
        int height = image.getHeight();
        double sin = Math.abs(Math.sin(Math.toRadians(angle)));
        double cos = Math.abs(Math.cos(Math.toRadians(angle)));
        int newWidth = (int)Math.floor((double)width * cos + (double)height * sin);
        int newHeight = (int)Math.floor((double)height * cos + (double)width * sin);
        BufferedImage rotatedImage = new BufferedImage(newWidth, newHeight, image.getType());
        Graphics2D g2d = rotatedImage.createGraphics();
        AffineTransform at = new AffineTransform();
        at.translate((newWidth - width) / 2, (newHeight - height) / 2);
        at.rotate(Math.toRadians(angle), width / 2, height / 2);
        g2d.setTransform(at);
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.dispose();
        return rotatedImage;
    }

    public static String getFilename(File file) {
        return file.getName();
    }

    public static String getSuffix(File file) {
        String suffix = null;
        String filename = ImageUtil.getFilename(file);
        int indexOf = filename.lastIndexOf(".");
        suffix = indexOf == -1 ? "" : filename.substring(indexOf + 1);
        if (suffix == null || "".equals(suffix.trim())) {
            suffix = ImageUtil.getFormatName(file);
        }
        return suffix;
    }

    public static Double getSizeKB(File file) {
        return (double)file.length() / 1024.0;
    }

    public static Double getSizeMB(File file) {
        return (double)file.length() / 1024.0 / 1024.0;
    }
}

