package cn.net.wanmo.common.image;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

/**
 * 旋转工具
 */
public class ImageRotateUtil {

    private static Logger logger = LoggerFactory.getLogger(ImageRotateUtil.class);


    /**
     * 图片旋转
     *
     * @param sourceImage 图片
     * @param angle       角度
     * @return 目标图片
     */
    public static File rotateImage(File sourceImage, double angle) {
        File targetFile = null;
        try {
            targetFile = File.createTempFile("image_rotate_", "." + ImageUtil.getSuffix(sourceImage));
            boolean flag = rotateImage(sourceImage, targetFile, angle);

            if (flag == false && targetFile != null) {
                targetFile.deleteOnExit();
                targetFile = null;
            }
        } catch (IOException e) {
            logger.error("图片旋转异常：" + sourceImage, e);
        }
        return targetFile;
    }


    /**
     * 图片旋转
     *
     * @param sourceImage 图片
     * @param targetImage 图片
     * @param angle       角度
     * @return 目标图片
     */
    public static boolean rotateImage(File sourceImage, File targetImage, double angle) {
        boolean flag = false;
        try {
            BufferedImage bufferedSource = ImageIO.read(sourceImage);
            BufferedImage bufferedTarget = rotateImage(bufferedSource, angle);
            ImageIO.write(bufferedTarget, ImageUtil.getFormatName(sourceImage), targetImage);
            flag = true;
        } catch (IOException e) {
            logger.error("图片旋转异常：" + sourceImage, e);
        }

        return flag;
    }

    /**
     * 图片旋转，图片模糊了
     *
     * @param image 图片
     * @param angle 角度
     * @return 目标图片
     */
    public static BufferedImage rotateImage(BufferedImage image, double angle) {
        return rotateImage_2(image, angle);
    }
    /**
     * 图片旋转，图片模糊了
     *
     * @param image 图片
     * @param angle 角度
     * @return 目标图片
     */
    public static BufferedImage rotateImage_1(BufferedImage image, double angle) {
        AffineTransform transform = new AffineTransform();
        transform.rotate(Math.toRadians(angle), image.getWidth() / 2, image.getHeight() / 2);

        AffineTransformOp op = new AffineTransformOp(transform, AffineTransformOp.TYPE_BILINEAR);
        BufferedImage rotatedImage = op.filter(image, null);

        return rotatedImage;
    }

    /**
     * 图片旋转，图片模糊了
     *
     * @param image 图片
     * @param angle 角度
     * @return 目标图片
     */
    public static BufferedImage rotateImage_2(BufferedImage image, double angle) {
        // 获取图片的中心点
        int width = image.getWidth();
        int height = image.getHeight();
        double sin = Math.abs(Math.sin(Math.toRadians(angle))),
                cos = Math.abs(Math.cos(Math.toRadians(angle)));
        int newWidth = (int) Math.floor(width * cos + height * sin),
                newHeight = (int) Math.floor(height * cos + width * sin);

        // 创建一个新的空白图片用于将原始图片绘制上去
        BufferedImage rotatedImage = new BufferedImage(newWidth, newHeight, image.getType());
        Graphics2D g2d = rotatedImage.createGraphics();

        // 设置旋转的中心点
        AffineTransform at = new AffineTransform();
        at.translate((newWidth - width) / 2, (newHeight - height) / 2);
        at.rotate(Math.toRadians(angle), width / 2, height / 2);
        g2d.setTransform(at);

        // 绘制图片
        g2d.drawImage(image, 0, 0, null);
        g2d.dispose();

        return rotatedImage;
    }
}
