package cn.net.wanmo.common.image;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

/**
 * 水印工具
 */
public class ImageWatermarkUtil {

    private static Logger logger = LoggerFactory.getLogger(ImageWatermarkUtil.class);


    /**
     * 添加文字水印
     *
     * @param srcImageFile 目标图片
     * @param text         文字内容
     * @param x            水印x坐标
     * @param y            水印y坐标
     * @return 结果图片
     */
    public static File watermarkText(File srcImageFile, String text, int x, int y) {
        File targetFile = null;
        try {
            targetFile = File.createTempFile("image_watermark_", "." + ImageUtil.getSuffix(srcImageFile));
            boolean flag = watermarkText(srcImageFile, targetFile, text, x, y);

            if (flag == false && targetFile != null) {
                targetFile.deleteOnExit();
                targetFile = null;
            }
        } catch (IOException e) {
            logger.error("添加文字水印异常：" + srcImageFile, e);
        }
        return targetFile;
    }


    /**
     * 添加文字水印
     *
     * @param srcImageFile 目标图片
     * @param targetFile   结果图片
     * @param text         文字内容
     * @param x            水印x坐标
     * @param y            水印y坐标
     * @return 结果图片
     */
    public static boolean watermarkText(File srcImageFile, File targetFile, String text, int x, int y) {
        boolean flag = false;
        try {
            //使用ImageIO的read方法读取图片
            BufferedImage read = ImageIO.read(srcImageFile);
            Graphics2D graphics = read.createGraphics();
            // 设置“抗锯齿”的属性
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            // 设置字体类型和大小
            graphics.setFont(new Font("微软雅黑", Font.PLAIN, 20));
            // 设置颜色
            graphics.setColor(new Color(255, 255, 255));
            // 添加文字
            graphics.drawString(text, x, y);
            graphics.dispose();

            // 使用ImageIO的write方法进行输出
            ImageIO.write(read, ImageUtil.getFormatName(srcImageFile), targetFile);
            flag = true;
        } catch (IOException e) {
            logger.error("添加文字水印异常：" + srcImageFile, e);
        }
        return flag;
    }


    /**
     * 添加图片水印
     *
     * @param srcImageFile 目标图片
     * @param waterImage   水印图片
     * @param x            水印x坐标
     * @param y            水印y坐标
     * @return 结果图片
     */
    public static File watermarkImage(File srcImageFile, File waterImage, int x, int y) {
        File targetFile = null;
        try {
            targetFile = File.createTempFile("image_watermark_", "." + ImageUtil.getSuffix(srcImageFile));
            boolean flag = watermarkImage(srcImageFile, targetFile, waterImage, x, y);

            if (flag == false && targetFile != null) {
                targetFile.deleteOnExit();
                targetFile = null;
            }
        } catch (IOException e) {
            logger.error("添加文字水印异常：" + srcImageFile, e);
        }
        return targetFile;

    }

    /**
     * 添加图片水印
     *
     * @param srcImageFile 目标图片
     * @param targetFile   结果图片
     * @param waterImage   水印图片
     * @param x            水印x坐标
     * @param y            水印y坐标
     * @return 是否成功
     */
    public static boolean watermarkImage(File srcImageFile, File targetFile, File waterImage, int x, int y) {
        boolean flag = false;
        try {
            //使用ImageIO的read方法读取图片
            BufferedImage read = ImageIO.read(srcImageFile);
            BufferedImage image = ImageIO.read(waterImage);
            //获取画布
            Graphics2D graphics = read.createGraphics();
            //设置透明度为0.5
            graphics.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_ATOP, 0.5f));
            //添加水印
            graphics.drawImage(image, x, y, null);
            //关闭透明度
            //graphics.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER));
            graphics.dispose();

            //使用ImageIO的write方法进行输出
            ImageIO.write(read, ImageUtil.getFormatName(srcImageFile), targetFile);
            flag = true;
        } catch (IOException e) {
            logger.error("添加图片水印异常：" + srcImageFile, e);
        }
        return flag;
    }

}
