/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.image;

import cn.net.wanmo.common.image.ImageUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageCutUtil {
    private static Logger logger = LoggerFactory.getLogger(ImageCutUtil.class);

    public static File cut(File srcImageFile, int x, int y, int width, int height) {
        File targetFile = null;
        try {
            targetFile = File.createTempFile("image_cut_", "." + ImageUtil.getSuffix(srcImageFile));
            boolean flag = ImageCutUtil.cut(srcImageFile, targetFile, x, y, width, height);
            if (!flag && targetFile != null) {
                targetFile.deleteOnExit();
                targetFile = null;
            }
        }
        catch (IOException e) {
            logger.error("\u88c1\u526a\u56fe\u7247\u5f02\u5e38\uff1a" + srcImageFile, (Throwable)e);
        }
        return targetFile;
    }

    public static boolean cut(File srcImageFile, File destImageFile, int x, int y, int width, int height) {
        boolean flag = false;
        try {
            BufferedImage read = ImageIO.read(srcImageFile);
            BufferedImage image = read.getSubimage(x, y, width, height);
            ImageIO.write((RenderedImage)image, ImageUtil.getFormatName(srcImageFile), destImageFile);
            flag = true;
        }
        catch (IOException e) {
            logger.error("\u88c1\u526a\u56fe\u7247\u5f02\u5e38\uff1a" + srcImageFile, (Throwable)e);
        }
        return flag;
    }
}

