/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.image;

import cn.net.wanmo.common.image.ImageUtil;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageResizeUtil {
    private static Logger logger = LoggerFactory.getLogger(ImageResizeUtil.class);

    public static File resizeWidth(File sourceFile, int scaledWidth) {
        File targetFile = null;
        try {
            targetFile = File.createTempFile("image_resize_", "." + ImageUtil.getSuffix(sourceFile));
            boolean flag = ImageResizeUtil.resize(sourceFile, targetFile, scaledWidth, 0);
            if (!flag && targetFile != null) {
                targetFile.deleteOnExit();
                targetFile = null;
            }
        }
        catch (IOException e) {
            logger.error("\u56fe\u7247\u5206\u8fa8\u7387\u538b\u7f29\u5f02\u5e38\uff1a" + sourceFile, (Throwable)e);
        }
        return targetFile;
    }

    public static File resizeHeight(File sourceFile, int scaledHeight) {
        File targetFile = null;
        try {
            targetFile = File.createTempFile("image_resize_", "." + ImageUtil.getSuffix(sourceFile));
            boolean flag = ImageResizeUtil.resize(sourceFile, targetFile, 0, scaledHeight);
            if (!flag && targetFile != null) {
                targetFile.deleteOnExit();
                targetFile = null;
            }
        }
        catch (IOException e) {
            logger.error("\u56fe\u7247\u5206\u8fa8\u7387\u538b\u7f29\u5f02\u5e38\uff1a" + sourceFile, (Throwable)e);
        }
        return targetFile;
    }

    public static boolean resize(File sourceFile, File targetFile, int scaledWidth, int scaledHeight) {
        try {
            double percentage;
            BufferedImage bufferedImage = ImageIO.read(sourceFile);
            int width = bufferedImage.getWidth();
            int height = bufferedImage.getHeight();
            if (scaledWidth == 0 && scaledHeight == 0) {
                scaledWidth = width;
                scaledHeight = height;
            }
            if (scaledWidth == 0) {
                percentage = (double)scaledHeight * 1.0 / (double)height;
                scaledWidth = Double.valueOf(percentage * (double)width).intValue();
            }
            if (scaledHeight == 0) {
                percentage = (double)scaledWidth * 1.0 / (double)width;
                scaledHeight = Double.valueOf(percentage * (double)height).intValue();
            }
            return ImageResizeUtil.resize(bufferedImage, scaledWidth, scaledHeight, targetFile, ImageUtil.getFormatName(sourceFile));
        }
        catch (IOException e) {
            logger.error("\u56fe\u7247\u5206\u8fa8\u7387\u538b\u7f29\u5f02\u5e38\uff1a" + sourceFile, (Throwable)e);
            return false;
        }
    }

    public static boolean resize(BufferedImage sourceImage, int scaledWidth, int scaledHeight, File targetFile, String formatName) {
        boolean flag = false;
        try {
            Image scaledInstance = sourceImage.getScaledInstance(scaledWidth, scaledHeight, 4);
            BufferedImage targetImage = new BufferedImage(scaledWidth, scaledHeight, sourceImage.getType());
            Graphics graphics = targetImage.getGraphics();
            graphics.drawImage(scaledInstance, 0, 0, null);
            graphics.dispose();
            ImageIO.write((RenderedImage)targetImage, formatName, targetFile);
            flag = true;
        }
        catch (IOException e) {
            logger.error("\u56fe\u7247\u5206\u8fa8\u7387\u538b\u7f29\u5f02\u5e38", (Throwable)e);
        }
        return flag;
    }
}

