/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.image;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtil {
    private static Logger logger = LoggerFactory.getLogger(ImageUtil.class);

    public static final boolean isImage(File file) {
        boolean flag = false;
        try {
            BufferedImage bufreader = ImageIO.read(file);
            if (bufreader == null) {
                flag = false;
            } else {
                int width = bufreader.getWidth();
                int height = bufreader.getHeight();
                flag = width != 0 && height != 0;
            }
        }
        catch (IOException e) {
            logger.error("\u5224\u65ad\u6587\u4ef6\u662f\u5426\u4e3a\u56fe\u7247\u5f02\u5e38\uff1a" + file, (Throwable)e);
        }
        return flag;
    }

    public static final String getFormatName(File file) {
        String formatName = null;
        try {
            if (ImageUtil.isImage(file)) {
                ImageInputStream iis = ImageIO.createImageInputStream(file);
                Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
                if (!iter.hasNext()) {
                    return null;
                }
                ImageReader reader = iter.next();
                iis.close();
                formatName = reader.getFormatName().toLowerCase();
            }
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6\u56fe\u7247 FormatName \u5f02\u5e38\uff1a" + file, (Throwable)e);
        }
        return formatName;
    }

    public static String getSuffix(File file) {
        return ImageUtil.getSuffix(file, true);
    }

    public static String getSuffix(File file, boolean isFormatName) {
        String suffix = null;
        String filename = ImageUtil.getFilename(file);
        int lastIndexOf = filename.lastIndexOf(".");
        suffix = lastIndexOf == -1 ? "" : filename.substring(lastIndexOf + 1);
        if (isFormatName && (suffix == null || "".equals(suffix.trim()))) {
            suffix = ImageUtil.getFormatName(file);
        }
        return suffix;
    }

    public static File renameSuffix(File file, String suffix) {
        if (file == null || !file.exists()) {
            logger.warn("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a{}", (Object)file);
            return file;
        }
        if (suffix.startsWith(".")) {
            suffix = suffix.substring(1);
        }
        String absolutePath = file.getAbsolutePath();
        String suffixTemp = ImageUtil.getSuffix(file, false);
        if (suffixTemp == null || "".equals(suffixTemp.trim())) {
            absolutePath = absolutePath + "." + suffix;
        } else {
            int lastIndexOf = absolutePath.lastIndexOf(".");
            absolutePath = absolutePath.substring(0, lastIndexOf + 1) + suffix;
        }
        File destFile = new File(absolutePath);
        file.renameTo(destFile);
        return destFile;
    }

    public static Double getSizeKB(File file) {
        if (file == null || !file.exists()) {
            return 0.0;
        }
        return (double)file.length() / 1024.0;
    }

    public static Double getSizeMB(File file) {
        if (file == null || !file.exists()) {
            return 0.0;
        }
        return (double)file.length() / 1024.0 / 1024.0;
    }

    public static String getFilename(File file) {
        return file.getName();
    }
}

