/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.image;

import cn.net.wanmo.common.image.ImageUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageWatermarkUtil {
    private static Logger logger = LoggerFactory.getLogger(ImageWatermarkUtil.class);

    public static File watermarkText(File srcImageFile, String text, int x, int y) {
        File targetFile = null;
        try {
            targetFile = File.createTempFile("image_watermark_", "." + ImageUtil.getSuffix(srcImageFile));
            boolean flag = ImageWatermarkUtil.watermarkText(srcImageFile, targetFile, text, x, y);
            if (!flag && targetFile != null) {
                targetFile.deleteOnExit();
                targetFile = null;
            }
        }
        catch (IOException e) {
            logger.error("\u6dfb\u52a0\u6587\u5b57\u6c34\u5370\u5f02\u5e38\uff1a" + srcImageFile, (Throwable)e);
        }
        return targetFile;
    }

    public static boolean watermarkText(File srcImageFile, File targetFile, String text, int x, int y) {
        boolean flag = false;
        try {
            BufferedImage read = ImageIO.read(srcImageFile);
            Graphics2D graphics = read.createGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 20));
            graphics.setColor(new Color(255, 255, 255));
            graphics.drawString(text, x, y);
            graphics.dispose();
            ImageIO.write((RenderedImage)read, ImageUtil.getFormatName(srcImageFile), targetFile);
            flag = true;
        }
        catch (IOException e) {
            logger.error("\u6dfb\u52a0\u6587\u5b57\u6c34\u5370\u5f02\u5e38\uff1a" + srcImageFile, (Throwable)e);
        }
        return flag;
    }

    public static File watermarkImage(File srcImageFile, File waterImage, int x, int y) {
        File targetFile = null;
        try {
            targetFile = File.createTempFile("image_watermark_", "." + ImageUtil.getSuffix(srcImageFile));
            boolean flag = ImageWatermarkUtil.watermarkImage(srcImageFile, targetFile, waterImage, x, y);
            if (!flag && targetFile != null) {
                targetFile.deleteOnExit();
                targetFile = null;
            }
        }
        catch (IOException e) {
            logger.error("\u6dfb\u52a0\u6587\u5b57\u6c34\u5370\u5f02\u5e38\uff1a" + srcImageFile, (Throwable)e);
        }
        return targetFile;
    }

    public static boolean watermarkImage(File srcImageFile, File targetFile, File waterImage, int x, int y) {
        boolean flag = false;
        try {
            BufferedImage read = ImageIO.read(srcImageFile);
            BufferedImage image = ImageIO.read(waterImage);
            Graphics2D graphics = read.createGraphics();
            graphics.setComposite(AlphaComposite.getInstance(10, 0.5f));
            graphics.drawImage((Image)image, x, y, null);
            graphics.dispose();
            ImageIO.write((RenderedImage)read, ImageUtil.getFormatName(srcImageFile), targetFile);
            flag = true;
        }
        catch (IOException e) {
            logger.error("\u6dfb\u52a0\u56fe\u7247\u6c34\u5370\u5f02\u5e38\uff1a" + srcImageFile, (Throwable)e);
        }
        return flag;
    }
}

