/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.image;

import cn.net.wanmo.common.image.ImageUtil;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageRotateUtil {
    private static Logger logger = LoggerFactory.getLogger(ImageRotateUtil.class);

    public static File rotateImage(File sourceImage, double angle) {
        File targetFile = null;
        try {
            targetFile = File.createTempFile("image_rotate_", "." + ImageUtil.getSuffix(sourceImage));
            boolean flag = ImageRotateUtil.rotateImage(sourceImage, targetFile, angle);
            if (!flag && targetFile != null) {
                targetFile.deleteOnExit();
                targetFile = null;
            }
        }
        catch (IOException e) {
            logger.error("\u56fe\u7247\u65cb\u8f6c\u5f02\u5e38\uff1a" + sourceImage, (Throwable)e);
        }
        return targetFile;
    }

    public static boolean rotateImage(File sourceImage, File targetImage, double angle) {
        boolean flag = false;
        try {
            BufferedImage bufferedSource = ImageIO.read(sourceImage);
            BufferedImage bufferedTarget = ImageRotateUtil.rotateImage(bufferedSource, angle);
            ImageIO.write((RenderedImage)bufferedTarget, ImageUtil.getFormatName(sourceImage), targetImage);
            flag = true;
        }
        catch (IOException e) {
            logger.error("\u56fe\u7247\u65cb\u8f6c\u5f02\u5e38\uff1a" + sourceImage, (Throwable)e);
        }
        return flag;
    }

    public static BufferedImage rotateImage(BufferedImage image, double angle) {
        return ImageRotateUtil.rotateImage_2(image, angle);
    }

    public static BufferedImage rotateImage_1(BufferedImage image, double angle) {
        AffineTransform transform = new AffineTransform();
        transform.rotate(Math.toRadians(angle), image.getWidth() / 2, image.getHeight() / 2);
        AffineTransformOp op = new AffineTransformOp(transform, 2);
        BufferedImage rotatedImage = op.filter(image, null);
        return rotatedImage;
    }

    public static BufferedImage rotateImage_2(BufferedImage image, double angle) {
        int width = image.getWidth();
        int height = image.getHeight();
        double sin = Math.abs(Math.sin(Math.toRadians(angle)));
        double cos = Math.abs(Math.cos(Math.toRadians(angle)));
        int newWidth = (int)Math.floor((double)width * cos + (double)height * sin);
        int newHeight = (int)Math.floor((double)height * cos + (double)width * sin);
        BufferedImage rotatedImage = new BufferedImage(newWidth, newHeight, image.getType());
        Graphics2D g2d = rotatedImage.createGraphics();
        AffineTransform at = new AffineTransform();
        at.translate((newWidth - width) / 2, (newHeight - height) / 2);
        at.rotate(Math.toRadians(angle), width / 2, height / 2);
        g2d.setTransform(at);
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.dispose();
        return rotatedImage;
    }
}

