package cn.net.wanmo.common.io;

import java.io.*;
import java.util.ArrayList;
import java.util.List;

/**
 * 按行读取
 */
public class ReadLineUtil {

    /**
     * 字符串按行读取
     *
     * @param str 字符串
     * @return 每行数据
     * @throws IOException 异常
     */
    public static List<String> readStr(String str) throws IOException {
        List<String> list = new ArrayList<>();

        BufferedReader bufferedReader = new BufferedReader(new StringReader(str));

        String line;
        while ((line = bufferedReader.readLine()) != null) {
            list.add(line);
        }

        return list;
    }

    /**
     * 文件按行读取
     *
     * @param file 文件
     * @return 每行数据
     * @throws IOException 异常
     */
    public static List<String> readFile(File file) throws IOException {
        List<String> list = new ArrayList<>();

        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));

        String line;
        while ((line = bufferedReader.readLine()) != null) {
            list.add(line);
        }

        return list;
    }
}
