/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.jwt;

import io.jsonwebtoken.lang.Assert;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class BuilderData {
    private String id;
    private Map<String, Object> header;
    private Map<String, Object> claims;
    private String payload;
    private String issuer;
    private Date issuedAt;
    private String subject;
    private String audience;
    private Date notBefore;
    private Integer expirationTime;

    public static BuilderData builder() {
        return new BuilderData();
    }

    public String getId() {
        return this.id;
    }

    public BuilderData setId(String id) {
        this.id = id;
        return this;
    }

    public Map<String, Object> getHeader() {
        return this.ensureHeader();
    }

    public BuilderData setHeader(Map<String, Object> header) {
        this.header = header;
        return this;
    }

    public BuilderData setHeaderParam(String name, Object value) {
        this.ensureHeader().put(name, value);
        return this;
    }

    public BuilderData header(String name, Object value) {
        Assert.hasText((String)name, (String)"header property name cannot be null or empty.");
        this.ensureHeader();
        if (value == null) {
            this.header.remove(name);
        } else {
            this.header.put(name, value);
        }
        return this;
    }

    protected Map<String, Object> ensureHeader() {
        if (this.header == null) {
            this.header = new HashMap<String, Object>();
        }
        return this.header;
    }

    public Map<String, Object> getClaims() {
        return this.ensureClaims();
    }

    public BuilderData setClaims(Map<String, Object> claims) {
        this.claims = claims;
        return this;
    }

    public BuilderData setClaimsParam(String name, Object value) {
        this.ensureClaims().put(name, value);
        return this;
    }

    public BuilderData claim(String name, Object value) {
        Assert.hasText((String)name, (String)"Claim property name cannot be null or empty.");
        this.ensureClaims();
        if (value == null) {
            this.claims.remove(name);
        } else {
            this.claims.put(name, value);
        }
        return this;
    }

    protected Map<String, Object> ensureClaims() {
        if (this.claims == null) {
            this.claims = new HashMap<String, Object>();
        }
        return this.claims;
    }

    public String getPayload() {
        return this.payload;
    }

    public BuilderData setPayload(String payload) {
        this.payload = payload;
        return this;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public BuilderData setIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public Date getIssuedAt() {
        return this.issuedAt;
    }

    public BuilderData setIssuedAt(Date issuedAt) {
        this.issuedAt = issuedAt;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public BuilderData setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public String getAudience() {
        return this.audience;
    }

    public BuilderData setAudience(String audience) {
        this.audience = audience;
        return this;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public BuilderData setNotBefore(Date notBefore) {
        this.notBefore = notBefore;
        return this;
    }

    public Integer getExpirationTime() {
        return this.expirationTime;
    }

    public BuilderData setExpirationTime(Integer expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }
}

