package cn.net.wanmo.common.jwt;

import io.jsonwebtoken.lang.Assert;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class BuilderData {
    private String id;
    private Map<String, Object> header;
    private Map<String, Object> claims;
    private String payload; // 负载信息
    private String issuer; // 签发者
    private Date issuedAt; // 签发时间
    private String subject; // 面向的用户
    private String audience; // 接收方
    private Date notBefore; // 生效时间
    private Integer expirationTime; // 截至时间（秒）

    public static BuilderData builder() {
        return new BuilderData();
    }

    public String getId() {
        return id;
    }

    public BuilderData setId(String id) {
        this.id = id;
        return this;
    }

    public Map<String, Object> getHeader() {
        return ensureHeader();
    }

    public BuilderData setHeader(Map<String, Object> header) {
        this.header = header;
        return this;
    }

    public BuilderData setHeaderParam(String name, Object value) {
        this.ensureHeader().put(name, value);
        return this;
    }

    public BuilderData header(String name, Object value) {
        Assert.hasText(name, "header property name cannot be null or empty.");
        this.ensureHeader();

        if (value == null) {
            this.header.remove(name);
        } else {
            this.header.put(name, value);
        }

        return this;
    }

    protected Map<String, Object> ensureHeader() {
        if (this.header == null) {
            this.header = new HashMap<>();
        }

        return this.header;
    }


    public Map<String, Object> getClaims() {
        return ensureClaims();
    }

    public BuilderData setClaims(Map<String, Object> claims) {
        this.claims = claims;
        return this;
    }

    public BuilderData setClaimsParam(String name, Object value) {
        this.ensureClaims().put(name, value);
        return this;
    }

    public BuilderData claim(String name, Object value) {
        Assert.hasText(name, "Claim property name cannot be null or empty.");
        this.ensureClaims();

        if (value == null) {
            this.claims.remove(name);
        } else {
            this.claims.put(name, value);
        }

        return this;
    }

    protected Map<String, Object> ensureClaims() {
        if (this.claims == null) {
            this.claims = new HashMap<>();
        }

        return this.claims;
    }


    public String getPayload() {
        return payload;
    }

    public BuilderData setPayload(String payload) {
        this.payload = payload;
        return this;
    }


    public String getIssuer() {
        return issuer;
    }

    public BuilderData setIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public Date getIssuedAt() {
        return issuedAt;
    }

    public BuilderData setIssuedAt(Date issuedAt) {
        this.issuedAt = issuedAt;
        return this;
    }

    public String getSubject() {
        return subject;
    }

    public BuilderData setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public String getAudience() {
        return audience;
    }

    public BuilderData setAudience(String audience) {
        this.audience = audience;
        return this;
    }

    public Date getNotBefore() {
        return notBefore;
    }

    public BuilderData setNotBefore(Date notBefore) {
        this.notBefore = notBefore;
        return this;
    }

    public Integer getExpirationTime() {
        return expirationTime;
    }

    public BuilderData setExpirationTime(Integer expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

}
