package cn.net.wanmo.common.mail.enums;

/**
 * SMTP 服务
 * 端口465（SMTPS）：使用隐式SSL/TLS进行加密
 * 端口587（SMTP提交端口）：显式SSL/TLS（STARTTLS）
 *
 * 常见邮件协议
 * SMTP (Simple Mail Transfer Protocol)：用于发送邮件。
 * IMAP (Internet Message Access Protocol)：用于接收邮件。
 * POP3 (Post Office Protocol 3)：另一种接收邮件的协议。
 */
public enum SmtpServer {
    smtp_outlook("smtp.office365.com", 465),
    smtp_yahoo("smtp.mail.yahoo.com.cn", 465),
    smtp_hotmail("smtp.live.com", 465),
    smtp_gmail("smtp.gmail.com", 465),
    smtp_21cn("smtp.21cn.com", 465),
    smtp_foxmail("smtp.foxmail.com", 465),
    smtp_sina("smtp.sina.com.cn", 465),
    smtp_sina_vip("smtp.vip.sina.com", 465),
    smtp_sina_qiye("smtp.sina.net", 465),
    smtp_tom("smtp.tom.com", 465),
    smtp_sohu("smtp.sohu.com", 465),
    smtp_sohu_qiye("mail.sohu.net", 465),
    smtp_263("smtp.263.net", 465),
    smtp_263cn("smtp.263.net.cn", 465),
    smtp_qq("smtp.qq.com", 587),
    smtp_qq_qiye("smtp.exmail.qq.com", 587),
    smtp_126 ("smtp.126.com", 465),
    smtp_163 ("smtp.163.com", 465),
    smtp_163_qiye ("smtp.qiye.163.com", 465);
;
    private final String host;
    private final int port;

    SmtpServer(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return host;
    }

    public int getPort() {
        return port;
    }
}
