package cn.net.wanmo.common.mail.pojo;

import cn.net.wanmo.common.mail.exception.MailException;

import javax.mail.internet.InternetAddress;

/**
 * 邮件地址
 */
public class MailAddress {
    /**
     * 邮件地址
     */
    private String address;
    /**
     * 发送人或接收人名称
     */
    private String personal;
    /**
     * 字符集
     */
    private String charset = "UTF-8";

    public MailAddress() {
    }

    public static MailAddress build(String address) {
        MailAddress mailAddress = new MailAddress();
        mailAddress.address = address;

        return mailAddress;
    }

    public static MailAddress build(String address, String personal) {
        MailAddress mailAddress = new MailAddress();
        mailAddress.address = address;
        mailAddress.personal = personal;

        return mailAddress;
    }

    public InternetAddress toInternetAddress() {
        try {
            return new InternetAddress(address, personal, charset);
        } catch (Exception e) {
            throw new MailException(e);
        }
    }
}
