package cn.net.wanmo.common.mail.pojo;

import java.util.ArrayList;
import java.util.List;

public class MailContent {
    /**
     * 字符集
     */
    private String charset = "UTF-8";
    /**
     * 内容是否是 HTML
     */
    private boolean isHtml;
    /**
     * 邮件内容
     */
    private String text;
    /**
     * 邮件附件
     */
    private List<Attach> attach = new ArrayList<>();

    public MailContent() {
    }

    public String getCharset() {
        return charset;
    }

    public MailContent setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public boolean isHtml() {
        return isHtml;
    }

    public MailContent setHtml(boolean html) {
        isHtml = html;
        return this;
    }

    public String getText() {
        return text;
    }

    public MailContent setText(String text) {
        this.text = text;
        return this;
    }

    public List<Attach> getAttach() {
        return attach;
    }

    public MailContent setAttach(List<Attach> attach) {
        this.attach = attach;
        return this;
    }

    /**
     * 添加附件
     *
     * @param filePath 附件绝对路径
     */
    public void addAttach(String filePath) {
        Attach e = new Attach();
        e.setFilePath(filePath);

        this.attach.add(e);
    }

    /**
     * 添加附件
     *
     * @param fileName 附件名称
     * @param filePath 附件绝对路径
     */
    public void addAttach(String fileName, String filePath) {
        Attach e = new Attach();
        e.setFileName(fileName);
        e.setFilePath(filePath);

        this.attach.add(e);
    }

    /**
     * 添加附件
     *
     * @param attachId 附件ID
     * @param fileName 附件名称
     * @param filePath 附件绝对路径
     */
    public void addAttach(String attachId, String fileName, String filePath) {
        Attach e = new Attach();
        e.setAttachId(attachId);
        e.setFileName(fileName);
        e.setFilePath(filePath);

        this.attach.add(e);
    }

    /**
     * 添加附件
     *
     * @param fileName    附件名称
     * @param filePath    附件绝对路径
     * @param contentType 文件类型
     * @param encoding    文件编码
     */
    public void addAttach(String fileName, String filePath, String contentType, String encoding) {
        Attach e = new Attach();
        e.setFileName(fileName);
        e.setFilePath(filePath);
        e.setContentType(contentType);
        e.setEncoding(encoding);

        this.attach.add(e);
    }


    /**
     * 附件
     */
    public class Attach {
        /**
         * 文件ID
         */
        private String attachId;
        /**
         * 文件名称
         */
        private String fileName;
        /**
         * 文件绝对路径
         */
        private String filePath;
        /**
         * 文件类型
         */
        private String contentType;
        /**
         * 文件编码
         */
        private String encoding;

        public Attach() {
        }

        public String getAttachId() {
            return attachId;
        }

        public Attach setAttachId(String attachId) {
            this.attachId = attachId;
            return this;
        }

        public String getFileName() {
            return fileName;
        }

        public Attach setFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public String getFilePath() {
            return filePath;
        }

        public Attach setFilePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public String getContentType() {
            return contentType;
        }

        public Attach setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public String getEncoding() {
            return encoding;
        }

        public Attach setEncoding(String encoding) {
            this.encoding = encoding;
            return this;
        }
    }
}
