/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.mail;

import cn.net.wanmo.common.mail.enums.SmtpServer;
import cn.net.wanmo.common.mail.exception.MailException;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class MailMessage {
    private Properties properties = new Properties();
    private String fromEmail;
    private String password;
    private String personal = "\u53d1\u4ef6\u4eba";
    private String charset = "UTF-8";
    private Session session;
    private Message message;

    public static MailMessage build(SmtpServer smtp) {
        return MailMessage.build(smtp.getHost(), smtp.getPort());
    }

    public static MailMessage build(String host, int port) {
        MailMessage message = new MailMessage();
        switch (port) {
            case 25: {
                message.port25(host, port);
                break;
            }
            case 465: {
                message.port465(host, port);
                break;
            }
            case 587: {
                message.port587(host, port);
                break;
            }
            default: {
                message.port465(host, port);
            }
        }
        return message;
    }

    public MailMessage createSession() {
        this.session = Session.getInstance((Properties)this.properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(MailMessage.this.fromEmail, MailMessage.this.password);
            }
        });
        return this;
    }

    public MailMessage createSession(String fromEmail, String password) {
        this.fromEmail = fromEmail;
        this.password = password;
        return this.createSession();
    }

    public MailMessage createMessage() {
        try {
            this.message = new MimeMessage(this.session);
            this.message.setFrom((Address)new InternetAddress(this.fromEmail, this.personal, this.charset));
        }
        catch (Exception e) {
            throw new MailException(e);
        }
        return this;
    }

    public Message ok() {
        return this.message;
    }

    private void port25(String host, int port) {
        this.properties.put("mail.smtp.host", host);
        this.properties.put("mail.smtp.port", (Object)port);
        this.properties.put("mail.smtp.auth", (Object)true);
    }

    private void port465(String host, int port) {
        this.properties.put("mail.smtp.host", host);
        this.properties.put("mail.smtp.port", (Object)port);
        this.properties.put("mail.smtp.auth", "true");
        this.properties.put("mail.smtp.ssl.enable", "true");
        this.properties.put("mail.smtp.socketFactory.port", (Object)port);
        this.properties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        this.properties.put("mail.smtp.socketFactory.fallback", "false");
    }

    private void port587(String host, int port) {
        this.properties.put("mail.smtp.host", host);
        this.properties.put("mail.smtp.port", (Object)port);
        this.properties.put("mail.smtp.auth", "true");
        this.properties.put("mail.smtp.starttls.enable", "true");
        this.properties.put("mail.smtp.starttls.required", "true");
    }

    public Properties getProperties() {
        return this.properties;
    }

    public MailMessage setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public String getFromEmail() {
        return this.fromEmail;
    }

    public MailMessage setFromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public MailMessage setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getPersonal() {
        return this.personal;
    }

    public MailMessage setPersonal(String personal) {
        this.personal = personal;
        return this;
    }

    public String getCharset() {
        return this.charset;
    }

    public MailMessage setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public Session getSession() {
        return this.session;
    }

    public MailMessage setSession(Session session) {
        this.session = session;
        return this;
    }

    public Message getMessage() {
        return this.message;
    }

    public MailMessage setMessage(Message message) {
        this.message = message;
        return this;
    }
}

