package cn.net.wanmo.common.mail.sun162;

import cn.net.wanmo.common.mail.sun162.enums.SmtpServer;
import cn.net.wanmo.common.mail.sun162.exception.MailException;

import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import java.util.Properties;

public class MailMessage {

    public static MailMessage build(SmtpServer smtp) {
        return build(smtp.getHost(), smtp.getPort());
    }

    public static MailMessage build(String host, int port) {
        MailMessage message = new MailMessage();

        switch (port) {
            case 25: {
                message.port25(host, port);
                break;
            }
            case 465: {
                message.port465(host, port);
                break;
            }
            case 587: {
                message.port587(host, port);
                break;
            }
            default: {
                message.port465(host, port);
            }
        }

        return message;
    }

    /**
     * 创建会话
     */
    public MailMessage createSession() {
        this.session = Session.getInstance(properties, new Authenticator() {
            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(fromEmail, password);
            }
        });

        return this;
    }

    /**
     * 创建会话
     */
    public MailMessage createSession(String fromEmail, String password) {
        this.fromEmail = fromEmail;
        this.password = password;
        return createSession();
    }

    /**
     * 创建消息对象
     */
    public MailMessage createMessage() {
        try {
            this.message = new MimeMessage(session);
            message.setFrom(new InternetAddress(fromEmail, personal, charset)); // 设置发件人
        } catch (Exception e) {
            throw new MailException(e);
        }
        return this;
    }

    /**
     * 创建完成
     */
    public Message ok() {
        return this.message;
    }


    private void port25(String host, int port) {
        properties.put("mail.smtp.host", host); // 设置邮件服务器主机名
        properties.put("mail.smtp.port", port); // 设置邮件服务器端口
        properties.put("mail.smtp.auth", true); // // 设置是否安全验证,默认为false,一般情况都设置为true
    }

    private void port465(String host, int port) {
        properties.put("mail.smtp.host", host); // SMTP 主机名（如 Gmail: smtp.gmail.com）
        properties.put("mail.smtp.port", port); // SMTP 端口号
        properties.put("mail.smtp.auth", "true"); // 是否需要认证
        properties.put("mail.smtp.ssl.enable", "true"); // 启用SSL加密
        properties.put("mail.smtp.socketFactory.port", port); // SSL端口号
        properties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory"); // SSL套接字工厂类名
        properties.put("mail.smtp.socketFactory.fallback", "false"); // 如果设置为true，则在SSL失败时尝试TLS
    }

    private void port587(String host, int port) {
        properties.put("mail.smtp.host", host); // SMTP 主机名（如 Gmail: smtp.gmail.com）
        properties.put("mail.smtp.port", port); // SMTP 端口号
        properties.put("mail.smtp.auth", "true"); // 是否需要认证
        properties.put("mail.smtp.starttls.enable", "true"); // 启用 STARTTLS
        properties.put("mail.smtp.starttls.required", "true"); // 要求使用TLS
    }

    /**
     * 配置 SMTP 服务器属性
     */
    private Properties properties = new Properties();
    /**
     * 发件人邮箱
     */
    private String fromEmail;
    /**
     * 邮箱密码或授权码（视邮箱服务商要求）
     */
    private String password;

    /**
     * 发件人名称
     */
    private String personal = "发件人";
    /**
     * 发件人名称字符集
     */
    private String charset = "UTF-8";
    /**
     * 会话
     */
    private Session session;

    private Message message;


    public Properties getProperties() {
        return properties;
    }

    public MailMessage setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public String getFromEmail() {
        return fromEmail;
    }

    public MailMessage setFromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
        return this;
    }

    public String getPassword() {
        return password;
    }

    public MailMessage setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getPersonal() {
        return personal;
    }

    public MailMessage setPersonal(String personal) {
        this.personal = personal;
        return this;
    }

    public String getCharset() {
        return charset;
    }

    public MailMessage setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public Session getSession() {
        return session;
    }

    public MailMessage setSession(Session session) {
        this.session = session;
        return this;
    }

    public Message getMessage() {
        return message;
    }

    public MailMessage setMessage(Message message) {
        this.message = message;
        return this;
    }
}
