/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.mail.sun162;

import cn.net.wanmo.common.mail.sun162.exception.MailException;
import cn.net.wanmo.common.mail.sun162.pojo.MailAddress;
import cn.net.wanmo.common.mail.sun162.pojo.MailContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Transport;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class MailSender {
    private String charset = "UTF-8";
    private Message message;
    private MailAddress toMail;
    private List<MailAddress> toMails = new ArrayList<MailAddress>();
    private List<MailAddress> ccMails = new ArrayList<MailAddress>();
    private List<MailAddress> bccMails = new ArrayList<MailAddress>();

    public static MailSender build(Message message) {
        MailSender sender = new MailSender();
        sender.message = message;
        return sender;
    }

    public MailSender sendText(String subject, String text) {
        try {
            this.message.setSubject(subject);
            this.message.setText(text);
        }
        catch (Exception e) {
            throw new MailException(e);
        }
        return this;
    }

    public MailSender sendHtml(String subject, String html) {
        try {
            this.message.setSubject(subject);
            this.message.setContent((Object)html, "text/html; charset=utf-8");
        }
        catch (Exception e) {
            throw new MailException(e);
        }
        return this;
    }

    public MailSender sendContent(String subject, MailContent content) {
        try {
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart bodyPart = new MimeBodyPart();
            if (content.isHtml()) {
                bodyPart.setContent((Object)content.getText(), "text/html; charset=utf-8");
            } else {
                bodyPart.setText(content.getText(), content.getCharset());
            }
            multipart.addBodyPart((BodyPart)bodyPart);
            if (Objects.nonNull(content.getAttach())) {
                for (MailContent.Attach attach : content.getAttach()) {
                    MimeBodyPart attachmentPart = new MimeBodyPart();
                    String attachId = attach.getAttachId();
                    if (Objects.nonNull(attachId) && attachId.trim().length() > 0) {
                        attachmentPart.setHeader("Content-ID", attachId);
                    }
                    attachmentPart.attachFile(attach.getFilePath());
                    String fileName = attach.getFileName();
                    if (Objects.nonNull(fileName) && fileName.trim().length() > 0) {
                        attachmentPart.setFileName(MimeUtility.encodeText((String)fileName));
                    }
                    multipart.addBodyPart((BodyPart)attachmentPart);
                }
            }
            this.message.setSubject(subject);
            this.message.setContent((Multipart)multipart);
        }
        catch (Exception e) {
            throw new MailException(e);
        }
        return this;
    }

    public void ok() {
        try {
            if (Objects.nonNull(this.toMail)) {
                this.message.setRecipient(Message.RecipientType.TO, (Address)this.toMail.toInternetAddress());
            }
            if (Objects.nonNull(this.toMails)) {
                for (MailAddress mailAddress : this.toMails) {
                    this.message.addRecipient(Message.RecipientType.TO, (Address)mailAddress.toInternetAddress());
                }
            }
            if (Objects.nonNull(this.ccMails)) {
                for (MailAddress mailAddress : this.ccMails) {
                    this.message.addRecipient(Message.RecipientType.CC, (Address)mailAddress.toInternetAddress());
                }
            }
            if (Objects.nonNull(this.bccMails)) {
                for (MailAddress mailAddress : this.bccMails) {
                    this.message.addRecipient(Message.RecipientType.BCC, (Address)mailAddress.toInternetAddress());
                }
            }
            Transport.send((Message)this.message);
        }
        catch (Exception e) {
            throw new MailException(e);
        }
    }

    public String getCharset() {
        return this.charset;
    }

    public MailSender setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public Message getMessage() {
        return this.message;
    }

    public MailSender setMessage(Message message) {
        this.message = message;
        return this;
    }

    public MailAddress getToMail() {
        return this.toMail;
    }

    public MailSender setToMail(MailAddress toMail) {
        this.toMail = toMail;
        return this;
    }

    public List<MailAddress> getToMails() {
        return this.toMails;
    }

    public MailSender setToMails(List<MailAddress> toMails) {
        this.toMails = toMails;
        return this;
    }

    public List<MailAddress> getCcMails() {
        return this.ccMails;
    }

    public MailSender setCcMails(List<MailAddress> ccMails) {
        this.ccMails = ccMails;
        return this;
    }

    public List<MailAddress> getBccMails() {
        return this.bccMails;
    }

    public MailSender setBccMails(List<MailAddress> bccMails) {
        this.bccMails = bccMails;
        return this;
    }
}

