package cn.net.wanmo.common.minio;

import cn.net.wanmo.common.util.BooleanUtil;
import cn.net.wanmo.common.util.Exceptions;
import io.minio.BucketExistsArgs;
import io.minio.MakeBucketArgs;
import io.minio.RemoveBucketArgs;
import io.minio.messages.Bucket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;

public class BucketUtil {
    private static Logger logger = LoggerFactory.getLogger(BucketUtil.class);

    /**
     * 检查存储桶是否存在
     *
     * @param bucketName 存储桶名称
     * @return 成功 true 失败 false
     */
    public static boolean bucketExists(String bucketName) {
        try {
            return MinioConfig.client.bucketExists(BucketExistsArgs.builder().bucket(bucketName).build());
        } catch (Exception e) {
            logger.error("检查存储桶是否存在 发生异常", e);
            throw Exceptions.unchecked(e);
        }
    }

    /**
     * 创建存储桶
     * @param bucketName 存储桶名称
     * @return 成功 true 失败 false
     */
    public static boolean makeBucket(String  bucketName) {
        try {
            final boolean flag = bucketExists(bucketName);
            if (BooleanUtil.isFalse(flag)) {
                MinioConfig.client.makeBucket(MakeBucketArgs.builder().bucket(bucketName).build());
            }
            logger.debug("Bucket '{}' is successfully created.", bucketName);
            return true;
        } catch (Exception e) {
            logger.error("创建存储桶 发生异常", e);
            throw Exceptions.unchecked(e);
        }
    }

    /**
     * 列出所有存储桶
     * @return 存储桶集合
     */
    public static List<Bucket> listBuckets() {
        try {
            return MinioConfig.client.listBuckets();
        } catch (Exception e) {
            logger.error("列出所有存储桶 发生异常", e);
            throw Exceptions.unchecked(e);
        }
    }

    /**
     * 列出所有存储桶名称
     * @return 存储桶名称集合
     */
    public static List<String> listBucketNames() {
        List<String> bucketListNames = new ArrayList<>();

        final List<Bucket> buckets = listBuckets();
        for (Bucket bucket : buckets) {
            bucketListNames.add(bucket.name());
        }

        return bucketListNames;
    }

    /**
     * 移除存储桶
     * @param bucketName 存储桶名称
     */
    public static void removeBucket(String  bucketName) {
        try {
            MinioConfig.client.removeBucket(RemoveBucketArgs.builder().bucket(bucketName).build());
        } catch (Exception e) {
            logger.error("移除存储桶 发生异常", e);
            throw Exceptions.unchecked(e);
        }
    }
}
