/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.poi;

import cn.net.wanmo.common.util.CollectionUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ooxml.POIXMLDocument;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

public class WordUtil {
    public static boolean isWord2003(String filePath) {
        return filePath.matches("^.+\\.(?i)(doc)$");
    }

    public static boolean isWord2007(String filePath) {
        return filePath.matches("^.+\\.(?i)(docx)$");
    }

    public static boolean validateWord(String filePath) {
        return filePath != null && (WordUtil.isWord2003(filePath) || WordUtil.isWord2007(filePath));
    }

    public static boolean replaceWord(String inputUrl, String outputUrl, Map<String, String> textMap) {
        boolean changeFlag = true;
        try {
            XWPFDocument document = WordUtil.replaceWord(inputUrl, textMap);
            File file = new File(outputUrl);
            FileOutputStream stream = new FileOutputStream(file);
            document.write((OutputStream)stream);
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            changeFlag = false;
        }
        return changeFlag;
    }

    public static XWPFDocument replaceWord(String inputUrl, Map<String, String> textMap) {
        try {
            XWPFDocument document = new XWPFDocument(POIXMLDocument.openPackage((String)inputUrl));
            WordUtil.changeParagraphText(document, textMap);
            WordUtil.changeTableText(document, textMap);
            return document;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void changeParagraphText(XWPFDocument document, Map<String, String> textMap) {
        if (textMap == null || textMap.isEmpty()) {
            return;
        }
        List paragraphs = document.getParagraphs();
        for (XWPFParagraph paragraph : paragraphs) {
            String text = paragraph.getText();
            if (!WordUtil.checkText(text)) continue;
            List runs = paragraph.getRuns();
            for (XWPFRun run : runs) {
                run.setText(WordUtil.changeValue(run.toString(), textMap), 0);
            }
        }
    }

    public static void changeTableText(XWPFDocument document, Map<String, String> textMap) {
        if (textMap == null || textMap.isEmpty()) {
            return;
        }
        List tables = document.getTables();
        for (int i = 0; i < tables.size(); ++i) {
            XWPFTable table = (XWPFTable)tables.get(i);
            if (table.getRows().size() <= 1 || !WordUtil.checkText(table.getText())) continue;
            List rows = table.getRows();
            WordUtil.eachTable(rows, textMap);
        }
    }

    public static void changeTable(XWPFDocument document, Map<String, String> textMap, List<String[]> tableList) {
        if (tableList == null || tableList.isEmpty()) {
            return;
        }
        List tables = document.getTables();
        for (int i = 0; i < tables.size(); ++i) {
            XWPFTable table = (XWPFTable)tables.get(i);
            if (table.getRows().size() <= 1) continue;
            if (WordUtil.checkText(table.getText())) {
                List rows = table.getRows();
                WordUtil.eachTable(rows, textMap);
                continue;
            }
            WordUtil.insertTable(table, tableList);
        }
    }

    public static void eachTable(List<XWPFTableRow> rows, Map<String, String> textMap) {
        for (XWPFTableRow row : rows) {
            List cells = row.getTableCells();
            for (XWPFTableCell cell : cells) {
                if (!WordUtil.checkText(cell.getText())) continue;
                List paragraphs = cell.getParagraphs();
                for (XWPFParagraph paragraph : paragraphs) {
                    List runs = paragraph.getRuns();
                    for (XWPFRun run : runs) {
                        run.setText(WordUtil.changeValue(run.toString(), textMap), 0);
                    }
                }
            }
        }
    }

    public static void insertTable(XWPFTable table, List<String[]> tableList) {
        if (CollectionUtil.isEmpty(tableList)) {
            return;
        }
        for (int i = 1; i < tableList.size(); ++i) {
            XWPFTableRow row = table.createRow();
            System.out.println(row);
        }
        List rows = table.getRows();
        for (int i = 1; i < rows.size(); ++i) {
            XWPFTableRow newRow = table.getRow(i);
            List cells = newRow.getTableCells();
            for (int j = 0; j < cells.size(); ++j) {
                XWPFTableCell cell = (XWPFTableCell)cells.get(j);
                cell.setText(tableList.get(i - 1)[j]);
            }
        }
    }

    public static boolean checkText(String text) {
        boolean check = false;
        if (text != null && text.indexOf("$") != -1) {
            check = true;
        }
        return check;
    }

    public static String changeValue(String value, Map<String, String> textMap) {
        Set<Map.Entry<String, String>> textSets = textMap.entrySet();
        for (Map.Entry<String, String> textSet : textSets) {
            String key = "${" + textSet.getKey() + "}";
            if (value == null || value.indexOf(key) == -1) continue;
            value = textSet.getValue();
        }
        if (WordUtil.checkText(value)) {
            value = "";
        }
        return value;
    }

    @Deprecated
    public static boolean changWord(String inputUrl, String outputUrl, Map<String, String> textMap, List<String[]> tableList) {
        boolean changeFlag = true;
        try {
            XWPFDocument document = WordUtil.changWord(inputUrl, textMap, tableList);
            File file = new File(outputUrl);
            FileOutputStream stream = new FileOutputStream(file);
            document.write((OutputStream)stream);
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            changeFlag = false;
        }
        return changeFlag;
    }

    @Deprecated
    public static XWPFDocument changWord(String inputUrl, Map<String, String> textMap, List<String[]> tableList) {
        try {
            XWPFDocument document = new XWPFDocument(POIXMLDocument.openPackage((String)inputUrl));
            WordUtil.changeParagraphText(document, textMap);
            WordUtil.changeTable(document, textMap, tableList);
            return document;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static XWPFDocument changWord(String inputUrl, Map<String, String> textMap) {
        return WordUtil.changWord(inputUrl, textMap, null);
    }

    public static void main(String[] args) {
        System.out.println(WordUtil.validateWord("aa.doca"));
    }
}

