package cn.net.wanmo.quartz.util;

import org.quartz.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

public class QuartzUtil {
    private static final Logger logger = LoggerFactory.getLogger(QuartzUtil.class);

    /**
     * 如果存在则重置任务
     * @param scheduler
     * @param jobKey
     * @return 是否重置
     * @throws SchedulerException
     */
    public static boolean checkJob(Scheduler scheduler, JobKey jobKey) throws SchedulerException {
        boolean checkExists = scheduler.checkExists(jobKey);

        if (checkExists) {
            scheduler.resumeJob(jobKey);
        }

        return checkExists;
    }

    public static void checkJob(JobDetail jobDetail, Trigger trigger, Scheduler scheduler) throws SchedulerException {
        //定义JobKey
        JobKey jobKey = jobDetail.getKey();

        boolean checkExistsJobKey = scheduler.checkExists(jobKey); // 检测是否存在任务
        boolean checkExistsTrigger = false;  // 检测是否存在触发器

        //判断是否存在，查询所有 的触发器
        List<? extends Trigger> triggersOfJob = scheduler.getTriggersOfJob(jobKey);
        logger.debug("任务 {} 存在的触发器数量：{}", jobKey, triggersOfJob.size());

        for (Trigger triggerTemp : triggersOfJob) {
            logger.debug("任务 {} 存在的触发器：{}", jobKey, triggerTemp.getKey());

            // 根据类型判断
            if ((triggerTemp instanceof CronTrigger) || (triggerTemp instanceof SimpleTrigger)) {
                checkExistsTrigger = true;
            }
        }

        if (checkExistsJobKey == true && checkExistsTrigger == true) {
            scheduler.resumeJob(jobKey);
            logger.debug("任务 {} 重置", jobKey);
        }

        if (checkExistsJobKey == false && checkExistsTrigger == true) {
            scheduler.deleteJob(jobKey);
            scheduler.scheduleJob(jobDetail, trigger);
            logger.debug("任务不存在，触发器存在， {} 删除后创建", jobKey);
        }

        if (checkExistsJobKey == true && checkExistsTrigger == false) {
            scheduler.deleteJob(jobKey);
            scheduler.scheduleJob(jobDetail, trigger);
            logger.debug("任务存在，触发器不存在， {} 删除后创建", jobKey);
        }

        if (checkExistsJobKey == false && checkExistsTrigger == false) {
            scheduler.scheduleJob(jobDetail, trigger);
            logger.debug("任务 {} 创建", jobKey);
        }
    }
}
