/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.quartz.util;

import java.util.List;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzUtil {
    private static final Logger logger = LoggerFactory.getLogger(QuartzUtil.class);

    public static boolean checkJob(Scheduler scheduler, JobKey jobKey) throws SchedulerException {
        boolean checkExists = scheduler.checkExists(jobKey);
        if (checkExists) {
            scheduler.resumeJob(jobKey);
        }
        return checkExists;
    }

    public static void checkJob(JobDetail jobDetail, Trigger trigger, Scheduler scheduler) throws SchedulerException {
        JobKey jobKey = jobDetail.getKey();
        boolean checkExistsJobKey = scheduler.checkExists(jobKey);
        boolean checkExistsTrigger = false;
        List triggersOfJob = scheduler.getTriggersOfJob(jobKey);
        logger.debug("\u4efb\u52a1 {} \u5b58\u5728\u7684\u89e6\u53d1\u5668\u6570\u91cf\uff1a{}", (Object)jobKey, (Object)triggersOfJob.size());
        for (Trigger triggerTemp : triggersOfJob) {
            logger.debug("\u4efb\u52a1 {} \u5b58\u5728\u7684\u89e6\u53d1\u5668\uff1a{}", (Object)jobKey, (Object)triggerTemp.getKey());
            if (!(triggerTemp instanceof CronTrigger) && !(triggerTemp instanceof SimpleTrigger)) continue;
            checkExistsTrigger = true;
        }
        if (checkExistsJobKey && checkExistsTrigger) {
            scheduler.resumeJob(jobKey);
            logger.debug("\u4efb\u52a1 {} \u91cd\u7f6e", (Object)jobKey);
        }
        if (!checkExistsJobKey && checkExistsTrigger) {
            scheduler.deleteJob(jobKey);
            scheduler.scheduleJob(jobDetail, trigger);
            logger.debug("\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u89e6\u53d1\u5668\u5b58\u5728\uff0c {} \u5220\u9664\u540e\u521b\u5efa", (Object)jobKey);
        }
        if (checkExistsJobKey && !checkExistsTrigger) {
            scheduler.deleteJob(jobKey);
            scheduler.scheduleJob(jobDetail, trigger);
            logger.debug("\u4efb\u52a1\u5b58\u5728\uff0c\u89e6\u53d1\u5668\u4e0d\u5b58\u5728\uff0c {} \u5220\u9664\u540e\u521b\u5efa", (Object)jobKey);
        }
        if (!checkExistsJobKey && !checkExistsTrigger) {
            scheduler.scheduleJob(jobDetail, trigger);
            logger.debug("\u4efb\u52a1 {} \u521b\u5efa", (Object)jobKey);
        }
    }
}

