/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.quartz.job;

import java.util.Date;
import org.quartz.CronScheduleBuilder;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisallowConcurrentExecution
@PersistJobDataAfterExecution
public abstract class BaseJob<CustomJob extends Job> {
    private final Logger logger = LoggerFactory.getLogger(BaseJob.class);
    private Class<CustomJob> customJobClass;

    protected void setCustomJobClass(Class<CustomJob> customJobClass) {
        this.customJobClass = customJobClass;
    }

    public JobDetail buildJobDetail(String name, String group) {
        return this.buildJobDetail(name, group, null, null);
    }

    public JobDetail buildJobDetail(String name, String group, JobDataMap jobDataMap) {
        return this.buildJobDetail(name, group, jobDataMap, null);
    }

    public JobDetail buildJobDetail(String name, String group, String jobDescription) {
        return this.buildJobDetail(name, group, null, jobDescription);
    }

    public JobDetail buildJobDetail(String name, String group, JobDataMap jobDataMap, String jobDescription) {
        jobDataMap = jobDataMap == null ? new JobDataMap() : jobDataMap;
        return JobBuilder.newJob(this.customJobClass).withIdentity(name, group).usingJobData(jobDataMap).withDescription(jobDescription).build();
    }

    public Trigger buildTrigger(String name, String group, ScheduleBuilder scheduleBuilder) {
        return this.buildTrigger(name, group, scheduleBuilder, null, null, null, 5, null);
    }

    public Trigger buildTrigger(String name, String group, ScheduleBuilder scheduleBuilder, JobDataMap jobDataMap) {
        return this.buildTrigger(name, group, scheduleBuilder, jobDataMap, null, null, 5, null);
    }

    public Trigger buildTrigger(String name, String group, ScheduleBuilder scheduleBuilder, JobDataMap jobDataMap, Date triggerStartTime, Date triggerEndTime, int triggerPriority, String triggerDescription) {
        jobDataMap = jobDataMap == null ? new JobDataMap() : jobDataMap;
        return TriggerBuilder.newTrigger().withIdentity(name, group).usingJobData(jobDataMap).withDescription(triggerDescription).startAt(triggerStartTime).endAt(triggerEndTime).withPriority(triggerPriority).startNow().withSchedule(scheduleBuilder).build();
    }

    public Scheduler start(JobDetail jobDetail, Trigger trigger) {
        try {
            Scheduler scheduler = StdSchedulerFactory.getDefaultScheduler();
            JobKey jobKey = jobDetail.getKey();
            if (scheduler.checkExists(jobKey)) {
                this.logger.debug("\u4efb\u52a1\u5df2\u5b58\u5728\uff1a" + jobKey);
                scheduler.resumeJob(jobKey);
            } else {
                this.logger.debug("\u4efb\u52a1\u4e0d\u5b58\u5728\uff1a" + jobKey);
                scheduler.scheduleJob(jobDetail, trigger);
            }
            this.logger.debug("\u4efb\u52a1\u542f\u52a8\uff1a" + jobKey);
            scheduler.start();
            return scheduler;
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public Scheduler start(String jobName, String triggerName, String groupName, String cronExpression) {
        JobDetail jobDetail = this.buildJobDetail(jobName, groupName);
        CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronExpression);
        Trigger trigger = this.buildTrigger(triggerName, groupName, (ScheduleBuilder)cronScheduleBuilder);
        return this.start(jobDetail, trigger);
    }
}

