/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.security.gm;

import cn.net.wanmo.common.codec.CodecUtil;
import cn.net.wanmo.common.security.gm.Sm2Util;
import cn.net.wanmo.common.util.Exceptions;
import java.security.MessageDigest;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;

public class Sm3Util {
    public static String digest(String data) {
        SM3Digest sm3Digest = new SM3Digest();
        byte[] dataBytes = data.getBytes();
        sm3Digest.update(dataBytes, 0, dataBytes.length);
        byte[] encrypt = new byte[sm3Digest.getDigestSize()];
        sm3Digest.doFinal(encrypt, 0);
        return CodecUtil.encodeHex((byte[])encrypt);
    }

    public static String digest(String data, String key) {
        SM3Digest digest = new SM3Digest();
        HMac mac = new HMac((Digest)digest);
        KeyParameter keyParameter = new KeyParameter(key.getBytes());
        mac.init((CipherParameters)keyParameter);
        byte[] dataBytes = data.getBytes();
        mac.update(dataBytes, 0, dataBytes.length);
        byte[] result = new byte[mac.getMacSize()];
        mac.doFinal(result, 0);
        return CodecUtil.encodeHex((byte[])result);
    }

    public static String digest_0(String data) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SM3", Sm2Util.provider);
            byte[] dataBytes = data.getBytes();
            byte[] result = messageDigest.digest(dataBytes);
            return CodecUtil.encodeHex((byte[])result);
        }
        catch (Exception e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }
}

