/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.security;

import cn.net.wanmo.common.codec.CodecUtil;
import cn.net.wanmo.common.util.Exceptions;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import org.apache.commons.lang3.Validate;

public class Digests {
    public static final String ALGORITHM_MD5 = "MD5";
    public static final String ALGORITHM_SHA1 = "SHA-1";
    public static final String ALGORITHM_SHA256 = "SHA-256";
    public static final String ALGORITHM_SHA512 = "SHA-512";
    public static SecureRandom random = new SecureRandom();

    public static String md5Hex(byte[] data) {
        return Digests.md5Hex(data, null, 1);
    }

    public static String md5Hex(byte[] data, int iterations) {
        return Digests.md5Hex(data, null, iterations);
    }

    public static String md5Hex(byte[] data, byte[] salt) {
        return Digests.md5Hex(data, salt, 1);
    }

    public static String md5Hex(byte[] data, byte[] salt, int iterations) {
        return Digests.digestHex(ALGORITHM_MD5, data, salt, iterations);
    }

    public static String md5Hex(InputStream is) {
        return Digests.digestHex(ALGORITHM_MD5, is);
    }

    public static String sha1Hex(byte[] data) {
        return Digests.sha1Hex(data, null, 1);
    }

    public static String sha1Hex(byte[] data, int iterations) {
        return Digests.sha1Hex(data, null, iterations);
    }

    public static String sha1Hex(byte[] data, byte[] salt) {
        return Digests.sha1Hex(data, salt, 1);
    }

    public static String sha1Hex(byte[] data, byte[] salt, int iterations) {
        return Digests.digestHex(ALGORITHM_SHA1, data, salt, iterations);
    }

    public static String sha1Hex(InputStream is) {
        return Digests.digestHex(ALGORITHM_SHA1, is);
    }

    public static String sha256Hex(byte[] data) {
        return Digests.sha256Hex(data, null, 1);
    }

    public static String sha256Hex(byte[] data, int iterations) {
        return Digests.sha256Hex(data, null, iterations);
    }

    public static String sha256Hex(byte[] data, byte[] salt) {
        return Digests.sha256Hex(data, salt, 1);
    }

    public static String sha256Hex(byte[] data, byte[] salt, int iterations) {
        return Digests.digestHex(ALGORITHM_SHA256, data, salt, iterations);
    }

    public static String sha256Hex(InputStream is) {
        return Digests.digestHex(ALGORITHM_SHA256, is);
    }

    public static String sha512Hex(byte[] data) {
        return Digests.sha512Hex(data, null, 1);
    }

    public static String sha512Hex(byte[] data, int iterations) {
        return Digests.sha512Hex(data, null, iterations);
    }

    public static String sha512Hex(byte[] data, byte[] salt) {
        return Digests.sha512Hex(data, salt, 1);
    }

    public static String sha512Hex(byte[] data, byte[] salt, int iterations) {
        return Digests.digestHex(ALGORITHM_SHA512, data, salt, iterations);
    }

    public static String sha512Hex(InputStream is) {
        return Digests.digestHex(ALGORITHM_SHA512, is);
    }

    public static byte[] digest(String algorithm, byte[] input) {
        return Digests.digest(algorithm, input, null, 1);
    }

    public static byte[] digest(String algorithm, byte[] input, int iterations) {
        return Digests.digest(algorithm, input, null, iterations);
    }

    public static byte[] digest(String algorithm, byte[] input, byte[] salt) {
        return Digests.digest(algorithm, input, salt, 1);
    }

    public static byte[] digest(String algorithm, byte[] input, byte[] salt, int iterations) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            if (salt != null) {
                messageDigest.update(salt);
            }
            byte[] result = messageDigest.digest(input);
            for (int i = 1; i < iterations; ++i) {
                messageDigest.reset();
                result = messageDigest.digest(result);
            }
            return result;
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    public static String digestHex(String algorithm, byte[] input, byte[] salt, int iterations) {
        byte[] digest = Digests.digest(algorithm, input, salt, iterations);
        return CodecUtil.encodeHex((byte[])digest);
    }

    public static byte[] digest(String algorithm, InputStream is) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            int bufferLength = 8192;
            byte[] buffer = new byte[bufferLength];
            int read = is.read(buffer, 0, bufferLength);
            while (read > -1) {
                messageDigest.update(buffer, 0, read);
                read = is.read(buffer, 0, bufferLength);
            }
            return messageDigest.digest();
        }
        catch (Exception e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    public static String digestHex(String algorithm, InputStream is) {
        byte[] digest = Digests.digest(algorithm, is);
        return CodecUtil.encodeHex((byte[])digest);
    }

    public static byte[] generateSalt(int numBytes) {
        Validate.isTrue((numBytes > 0 ? 1 : 0) != 0, (String)"numBytes argument must be a positive integer (1 or larger)", (long)numBytes);
        byte[] bytes = new byte[numBytes];
        random.nextBytes(bytes);
        return bytes;
    }
}

