package cn.net.wanmo.common.security.pojo;

import cn.net.wanmo.common.util.FileUtil;

import java.io.File;
import java.io.Serializable;

/**
 * 非对称密钥的 文件形式
 */
public class KeyPairFiles implements Serializable {
    private File publicKey;
    private File privateKey;

    public KeyPairFiles() {
    }

    public KeyPairFiles(File publicKey, File privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public KeyPairFiles(String publicKeyFilePath, String privateKeyFilePath) {
        this.publicKey = new File(publicKeyFilePath);
        this.privateKey = new File(privateKeyFilePath);

        if (this.publicKey.exists() == false) {
            FileUtil.createFile(publicKeyFilePath);
        }
        if (this.privateKey.exists() == false) {
            FileUtil.createFile(privateKeyFilePath);
        }
    }

    public File getPublicKey() {
        return publicKey;
    }

    public void setPublicKey(File publicKey) {
        this.publicKey = publicKey;
    }

    public File getPrivateKey() {
        return privateKey;
    }

    public void setPrivateKey(File privateKey) {
        this.privateKey = privateKey;
    }
}
