/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.security.crypto;

import cn.net.wanmo.common.codec.CodecUtil;
import cn.net.wanmo.common.security.Digests;
import cn.net.wanmo.common.security.symmetry.AesUtil;
import cn.net.wanmo.common.util.Exceptions;
import cn.net.wanmo.common.util.StringUtil;

public class PasswordUtil {
    public static final String HASH_ALGORITHM = "SHA-1";
    public static final int HASH_INTERATIONS = 1024;
    public static final int SALT_SIZE = 8;

    public static String entryptPassword(String plainPassword) {
        String plain = CodecUtil.unescapeHtml((String)plainPassword);
        byte[] salt = Digests.generateSalt(8);
        String hashPassword = Digests.sha1Hex(plain.getBytes(), salt, 1024);
        return CodecUtil.encodeHex((byte[])salt) + hashPassword;
    }

    public static boolean validatePassword(String plainPassword, String password) {
        String plain = CodecUtil.unescapeHtml((String)plainPassword);
        byte[] salt = CodecUtil.decodeHex((String)password.substring(0, 16));
        String hashPassword = Digests.sha1Hex(plain.getBytes(), salt, 1024);
        return password.equals(CodecUtil.encodeHex((byte[])salt) + hashPassword);
    }

    public static String enPwd(String pwd) {
        try {
            String keyStr = AesUtil.getRandomKey();
            String encryptStr = AesUtil.encrypt(pwd, keyStr);
            return CodecUtil.decodeBase64String((String)keyStr) + encryptStr;
        }
        catch (Exception e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }

    public static String dePwd(String pwd) {
        try {
            if (StringUtil.isBlank((CharSequence)pwd)) {
                return "";
            }
            String keyStr = pwd.substring(0, 16);
            String encryptStr = pwd.substring(16);
            String decryptStr = AesUtil.decrypt(encryptStr, CodecUtil.encodeBase64((String)keyStr));
            return decryptStr;
        }
        catch (Exception e) {
            throw Exceptions.unchecked((Exception)e);
        }
    }
}

