/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Set;

public class JavaTimeUtil {
    public static LocalDateTime nowLocalDateTime() {
        return JavaTimeUtil.nowLocalDateTime1();
    }

    private static LocalDateTime nowLocalDateTime1() {
        return LocalDateTime.now(ZoneId.of(ZoneId.SHORT_IDS.get("CTT")));
    }

    private static LocalDateTime nowLocalDateTime2() {
        return LocalDateTime.now(ZoneId.of("Asia/Shanghai"));
    }

    public static LocalDate nowLocalDate() {
        return LocalDate.now(ZoneId.of(ZoneId.SHORT_IDS.get("CTT")));
    }

    public static LocalTime nowLocalTime() {
        return LocalTime.now(ZoneId.of(ZoneId.SHORT_IDS.get("CTT")));
    }

    public static String formatDay() {
        return JavaTimeUtil.formatDayTime(JavaTimeUtil.nowLocalDateTime());
    }

    public static String formatDay(LocalDateTime localDateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.CHINA);
        return localDateTime.format(formatter);
    }

    public static String formatDayTime() {
        return JavaTimeUtil.formatDayTime(JavaTimeUtil.nowLocalDateTime());
    }

    public static String formatDayTime(LocalDateTime localDateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
        return localDateTime.format(formatter);
    }

    public static LocalDateTime minusDays(long days) {
        return JavaTimeUtil.nowLocalDateTime().minusDays(days);
    }

    public static LocalDateTime minusDays(LocalDateTime localDateTime, long days) {
        return localDateTime.minusDays(days);
    }

    public static LocalDateTime plusDays(long days) {
        return JavaTimeUtil.nowLocalDateTime().plusDays(days);
    }

    public static LocalDateTime plusDays(LocalDateTime localDateTime, long days) {
        return localDateTime.plusDays(days);
    }

    public static boolean isEqual(LocalDate localDate1, LocalDate localDate2) {
        return localDate1.isEqual(localDate2);
    }

    public static boolean isEqual(LocalDateTime localDateTime1, LocalDateTime localDateTime2) {
        return localDateTime1.isEqual(localDateTime2);
    }

    public static void printZoneIds() {
        Set<String> zoneIds = ZoneId.getAvailableZoneIds();
        zoneIds.stream().iterator().forEachRemaining(s -> System.out.println((String)s));
    }
}

