package cn.net.wanmo.common.charset;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

/**
 * Charset 工具类
 */
public class CharsetUtil {

	/** 默认 CharSet UTF8 */
	public static final String UTF8_NAME = StandardCharsets.UTF_8.name();
	/** 默认 CharSet UTF8 */
	public static final Charset UTF8 = StandardCharsets.UTF_8;

	/** 默认 CharSet GBK */
	public static final String GBK_NAME = "GBK";
	/** 默认 CharSet GBK */
	public static final Charset GBK = Charset.isSupported(GBK_NAME) ? null : Charset.forName(GBK_NAME);

	/** 默认 CharSet */
	public static final String DEFAULT_NAME = Charset.defaultCharset().name();
	/** 默认 CharSet */
	public static final Charset DEFAULT = Charset.defaultCharset();

}
