package cn.net.wanmo.common.config;

import cn.net.wanmo.common.util.Ini4jUtil;
import cn.net.wanmo.common.util.StringUtil;
import org.ini4j.Profile;

/**
 * 从配置文件取值，优先从配置文件 "config/wanmo-config.ini" 中取值，再从 "config/wanmo-common-config.ini" 中取值
 */
public class CommonConfig {
    private static final String SECTION_NAME = "wanmo-common";
    private static final String CONFIG_FILE = "config/wanmo-common-config.ini";

    private static final Profile.Section sectionDefault;
    private static final Profile.Section sectionCurrent;

    static {
        sectionDefault = Ini4jUtil.getSection(SECTION_NAME);
        sectionCurrent = Ini4jUtil.getSection(Ini4jUtil.getIni(CONFIG_FILE), SECTION_NAME);
    }

    public static String get(String key) {
        String value = Ini4jUtil.getValue(sectionDefault, key);

        if (StringUtil.isBlank(value)) {
            value = Ini4jUtil.getValue(sectionCurrent, key);
        }

        return value;
    }

    public static String getTestKey() {
        return get("test-key");
    }
}
