package cn.net.wanmo.common.pojo;

import cn.net.wanmo.common.util.StringUtil;

import java.io.Serializable;

/**
 * 日期时间范围
 */
public class DateRange implements Serializable {
	private static final long serialVersionUID = 1L;

	/** 开始时间 */
	private String startDate;
	/** 结束时间 */
	private String endDate;
	/** 当前时间 */
	private String currentDate;

	public DateRange() {
		super();
	}

	/** 获取开始时间 */
	public String getStartDate() {
		return startDate;
	}
	/** 设置开始时间 */
	public void setStartDate(String startDate) {
		this.startDate = startDate;
	}
	/** 获取结束时间 */
	public String getEndDate() {
		return endDate;
	}
	/** 设置结束时间 */
	public void setEndDate(String endDate) {
		this.endDate = endDate;
	}
	/** 获取当前时间 */
	public String getCurrentDate() {
		return currentDate;
	}
	/** 设置当前时间 */
	public void setCurrentDate(String currentDate) {
		this.currentDate = currentDate;
	}

	@Override
	public String toString() {
		if (StringUtil.isBlank(startDate) || StringUtil.isBlank(endDate)) {
			return null;
		}
		return String.format("%s ~ %s", startDate, endDate);
	}

}
