package cn.net.wanmo.common.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Set;

/**
 * Java8 后的时间工具类
 */
public class JavaTimeUtil {

    /**
     * 当前的 LocalDateTime
     *
     * @return LocalDateTime
     */
    public static LocalDateTime nowLocalDateTime() {
        return nowLocalDateTime1();
    }


    /**
     * 当前的 LocalDateTime
     *
     * @return LocalDateTime
     */
    private static LocalDateTime nowLocalDateTime1() {
        return LocalDateTime.now(ZoneId.of(ZoneId.SHORT_IDS.get("CTT")));
    }


    /**
     * 当前的 LocalDateTime
     *
     * @return LocalDateTime
     */
    private static LocalDateTime nowLocalDateTime2() {
        return LocalDateTime.now(ZoneId.of("Asia/Shanghai"));
    }


    /**
     * 当前的 LocalDate
     *
     * @return LocalDate
     */
    public static LocalDate nowLocalDate() {
        return LocalDate.now(ZoneId.of(ZoneId.SHORT_IDS.get("CTT")));
    }

    /**
     * 当前的 LocalTime
     *
     * @return LocalTime
     */
    public static LocalTime nowLocalTime() {
        return LocalTime.now(ZoneId.of(ZoneId.SHORT_IDS.get("CTT")));
    }


    /**
     * 当前的 LocalDateTime "yyyy-MM-dd"
     *
     * @return LocalDateTime
     */
    public static String formatDay() {
        return formatDayTime(nowLocalDateTime());
    }

    /**
     * 当前的 LocalDateTime "yyyy-MM-dd"
     *
     * @return LocalDateTime
     */
    public static String formatDay(LocalDateTime localDateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.CHINA);
        return localDateTime.format(formatter);
    }

    /**
     * 当前的 LocalDateTime "yyyy-MM-dd HH:mm:ss"
     *
     * @return LocalDateTime
     */
    public static String formatDayTime() {
        return formatDayTime(nowLocalDateTime());
    }

    /**
     * 当前的 LocalDateTime "yyyy-MM-dd HH:mm:ss"
     *
     * @return LocalDateTime
     */
    public static String formatDayTime(LocalDateTime localDateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
        return localDateTime.format(formatter);
    }

    /**
     * 几天前
     *
     * @param days 天数
     * @return LocalDateTime
     */
    public static LocalDateTime minusDays(long days) {
        return nowLocalDateTime().minusDays(days);
    }

    /**
     * 几天前
     *
     * @param localDateTime 日期和时间
     * @param days          天数
     * @return LocalDateTime
     */
    public static LocalDateTime minusDays(LocalDateTime localDateTime, long days) {
        return localDateTime.minusDays(days);
    }

    /**
     * 几天后
     *
     * @param days 天数
     * @return LocalDateTime
     */
    public static LocalDateTime plusDays(long days) {
        return nowLocalDateTime().plusDays(days);
    }

    /**
     * 几天后
     *
     * @param localDateTime 日期和时间
     * @param days          天数
     * @return LocalDateTime
     */
    public static LocalDateTime plusDays(LocalDateTime localDateTime, long days) {
        return localDateTime.plusDays(days);
    }

    /**
     * 日期是否一致
     *
     * @param localDate1 日期1
     * @param localDate2 日期2
     * @return 是否一致
     */
    public static boolean isEqual(LocalDate localDate1, LocalDate localDate2) {
        return localDate1.isEqual(localDate2);
    }

    /**
     * 日期和时间是否一致
     *
     * @param localDateTime1 日期时间1
     * @param localDateTime2 日期时间2
     * @return 是否一致
     */
    public static boolean isEqual(LocalDateTime localDateTime1, LocalDateTime localDateTime2) {
        return localDateTime1.isEqual(localDateTime2);
    }

    /**
     * 打印 ZoneIds
     */
    public static void printZoneIds() {
        Set<String> zoneIds = ZoneId.getAvailableZoneIds(); // Asia/Shanghai
        zoneIds.stream().iterator().forEachRemaining(s -> {
            System.out.println(s);
        });
    }
}
